/*
 * Decompiled with CFR 0.152.
 */
package units;

import java.util.Hashtable;
import units.DefinedFunction;
import units.Entity;
import units.Env;
import units.EvalError;
import units.Function;
import units.Ignore;
import units.Location;
import units.Prefix;
import units.Unit;
import units.UnitList;
import units.Value;

class Alias
extends Entity {
    final String unitList;
    static Hashtable<String, Alias> table = null;

    Alias(String name, String ulist, Location loc) {
        super(name, loc);
        this.unitList = ulist.replace(" ", "").replace("\t", "");
    }

    static void define(String name, String ulist, Location loc) {
        String diag = Entity.checkName(name);
        if (diag != null) {
            Env.out.println(loc.where() + ". Alias '" + name + "' is ignored. It " + diag + ".");
            return;
        }
        Alias old = table.put(name, new Alias(name, ulist, loc));
        if (old != null) {
            Env.out.println("Unit list '" + name + "' defined in " + old.location.where() + ", is redefined in " + loc.where() + ".");
        }
    }

    @Override
    void check() {
        Prefix pref;
        Unit unit;
        String where = this.location.where() + ". ";
        if (Env.verbose == 2) {
            Env.out.println(where + "Doing '" + this.name + "'.");
        }
        try {
            UnitList ul = new UnitList(this.unitList);
        }
        catch (EvalError e) {
            Env.out.println(where + "Unit list '" + this.name + "'. " + e.getMessage());
        }
        Function func = DefinedFunction.table.get(this.name);
        if (func != null) {
            Env.out.println(where + "Unit list '" + this.name + "' hides the function defined in " + func.location.where() + ".");
        }
        if ((unit = Unit.table.get(this.name)) != null) {
            Env.out.println(where + "Unit list '" + this.name + "' hides the unit defined in " + unit.location.where() + ".");
        }
        if ((pref = Prefix.table.get(this.name)) != null) {
            Env.out.println(where + "Unit list '" + this.name + "' hides the prefix defined in " + pref.location.where() + ".");
        }
    }

    @Override
    boolean conformsTo(Value v) {
        UnitList ul;
        try {
            ul = new UnitList(this.unitList);
        }
        catch (EvalError e) {
            return false;
        }
        return ul.value[0].isCompatibleWith(v, Ignore.DIMLESS);
    }

    static String showdef(String name) {
        Alias alias = table.get(name);
        if (alias != null) {
            return "unit list, " + alias.unitList;
        }
        return null;
    }

    @Override
    String desc() {
        return "= " + this.unitList;
    }
}

