/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class JavaClassPathUtil {
    public static String generateClassPath(char sep, File jarDir) {
        File[] contents;
        StringBuilder builder = new StringBuilder();
        File[] fileArray = contents = jarDir.listFiles();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            File entry = fileArray[n2];
            if (entry.isFile()) {
                String str = entry.toString();
                int idx = str.indexOf("jar");
                if (idx != -1) {
                    str = str.substring(idx);
                }
                if (builder.length() > 0) {
                    builder.append(sep);
                }
                str = sep == ':' ? JavaClassPathUtil.adjustDirSymbol(str, '/') : JavaClassPathUtil.adjustDirSymbol(str, '\\');
                builder.append(str);
            }
            ++n2;
        }
        return builder.toString();
    }

    private static String adjustDirSymbol(String str, char replace) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == File.separatorChar) {
                ch = replace;
            }
            result.append(ch);
            ++i;
        }
        return result.toString();
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Please pass the workbench directory as arg 1");
        } else {
            try {
                File baseDir = new File(args[0]);
                File jarDir = new File(baseDir, "jar");
                StringBuilder batCommand = new StringBuilder();
                batCommand.append("start javaw -classpath ");
                batCommand.append(JavaClassPathUtil.generateClassPath(';', jarDir));
                batCommand.append(" org.encog.workbench.EncogWorkBench");
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(new File(baseDir, "workbench.bat"))));
                out.println(batCommand);
                out.close();
                StringBuilder shCommand = new StringBuilder();
                shCommand.append("java -classpath ");
                shCommand.append(JavaClassPathUtil.generateClassPath(':', jarDir));
                shCommand.append(" org.encog.workbench.EncogWorkBench");
                out = new PrintWriter(new BufferedWriter(new FileWriter(new File(baseDir, "workbench.sh"))));
                out.println(shCommand);
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

