/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.bayesian;

import org.encog.util.Format;
import org.encog.workbench.tabs.visualize.bayesian.DrawnEvent;

public class DrawnEventConnection {
    private final DrawnEvent from;
    private final DrawnEvent to;
    private final double weight;
    private boolean context;

    public DrawnEventConnection(DrawnEvent from, DrawnEvent to) {
        this.from = from;
        this.to = to;
        this.weight = 0.0;
        this.context = false;
    }

    public DrawnEvent getFrom() {
        return this.from;
    }

    public DrawnEvent getTo() {
        return this.to;
    }

    public double getWeight() {
        return this.weight;
    }

    public String getToolTip() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.from.getName());
        builder.append("->");
        builder.append(this.to.getName());
        builder.append(" : ");
        builder.append(Format.formatDouble(this.weight, 4));
        return builder.toString();
    }

    public boolean isContext() {
        return this.context;
    }

    public void setContext(boolean context) {
        this.context = context;
    }
}

