/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.visualize.bayesian;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout2;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.renderers.BasicVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.encog.ml.bayesian.BayesianEvent;
import org.encog.ml.bayesian.BayesianNetwork;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.visualize.bayesian.DrawnEvent;
import org.encog.workbench.tabs.visualize.bayesian.DrawnEventConnection;

public class BayesianStructureTab
extends EncogCommonTab {
    private VisualizationViewer<DrawnEvent, DrawnEventConnection> vv;
    private Graph<DrawnEvent, DrawnEventConnection> graph;

    private static Class<? extends Layout>[] getCombos() {
        ArrayList<Class> layouts = new ArrayList<Class>();
        layouts.add(KKLayout.class);
        layouts.add(FRLayout.class);
        layouts.add(CircleLayout.class);
        layouts.add(SpringLayout.class);
        layouts.add(SpringLayout2.class);
        layouts.add(ISOMLayout.class);
        return layouts.toArray(new Class[0]);
    }

    public BayesianStructureTab(BayesianNetwork method) {
        super((ProjectFile)null);
        this.graph = this.buildGraph(method);
        KKLayout layout = new KKLayout(this.graph);
        this.vv = new VisualizationViewer((Layout)layout);
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.vv.getRenderContext().setVertexLabelTransformer((Function)new ToStringLabeller());
        this.vv.getRenderer().getVertexLabelRenderer().setPositioner((Renderer.VertexLabel.Positioner)new BasicVertexLabelRenderer.InsidePositioner());
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.N);
        this.vv.setVertexToolTipTransformer((Function)new Function<DrawnEvent, String>(){

            public String apply(DrawnEvent edge) {
                return edge.getToolTip();
            }
        });
        Function<DrawnEvent, Paint> vertexPaint = new Function<DrawnEvent, Paint>(){

            public Paint apply(DrawnEvent neuron) {
                return Color.white;
            }
        };
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        this.vv.getRenderContext().setVertexFillPaintTransformer((Function)vertexPaint);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        Class<? extends Layout>[] combos = BayesianStructureTab.getCombos();
        JComboBox<Class<? extends Layout>> jcb = new JComboBox<Class<? extends Layout>>(combos);
        jcb.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String valueString = value.toString();
                valueString = valueString.substring(valueString.lastIndexOf(46) + 1);
                return super.getListCellRendererComponent((JList<?>)list, valueString, index, isSelected, cellHasFocus);
            }
        });
        jcb.addActionListener(new LayoutChooser(jcb, this.vv));
        jcb.setSelectedItem(FRLayout.class);
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)BayesianStructureTab.this.vv, 1.1f, BayesianStructureTab.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            private final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale((VisualizationServer)BayesianStructureTab.this.vv, 0.9090909f, BayesianStructureTab.this.vv.getCenter());
            }
        });
        JButton reset = new JButton("reset");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BayesianStructureTab.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).setToIdentity();
                BayesianStructureTab.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW).setToIdentity();
            }
        });
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(((DefaultModalGraphMouse)this.vv.getGraphMouse()).getModeListener());
        JPanel controls = new JPanel();
        controls.setLayout(new FlowLayout(0));
        controls.add(plus);
        controls.add(minus);
        controls.add(reset);
        controls.add(modeBox);
        controls.add(jcb);
        Border border = BorderFactory.createEtchedBorder();
        controls.setBorder(border);
        this.add((Component)controls, "North");
    }

    private Graph<DrawnEvent, DrawnEventConnection> buildGraph(BayesianNetwork network) {
        ArrayList<DrawnEvent> events = new ArrayList<DrawnEvent>();
        SparseMultigraph result = new SparseMultigraph();
        ArrayList connections = new ArrayList();
        HashMap<BayesianEvent, DrawnEvent> eventMap = new HashMap<BayesianEvent, DrawnEvent>();
        for (BayesianEvent bayesianEvent : network.getEvents()) {
            DrawnEvent drawnEvent = new DrawnEvent(bayesianEvent);
            events.add(drawnEvent);
            eventMap.put(bayesianEvent, drawnEvent);
        }
        for (BayesianEvent bayesianEvent : network.getEvents()) {
            for (BayesianEvent childEvent : bayesianEvent.getChildren()) {
                DrawnEvent fromEvent = (DrawnEvent)eventMap.get(bayesianEvent);
                DrawnEvent toEvent = (DrawnEvent)eventMap.get(childEvent);
                if (fromEvent == null || toEvent == null) continue;
                DrawnEventConnection connection = new DrawnEventConnection(fromEvent, toEvent);
                fromEvent.getOutbound().add(connection);
                toEvent.getInbound().add(connection);
            }
        }
        for (DrawnEvent drawnEvent : events) {
            result.addVertex((Object)drawnEvent);
            for (DrawnEventConnection connection : drawnEvent.getOutbound()) {
                result.addEdge((Object)connection, (Object)connection.getFrom(), (Object)connection.getTo(), EdgeType.DIRECTED);
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return "Structure: " + this.getEncogObject().getName();
    }

    private final class LayoutChooser
    implements ActionListener {
        private final JComboBox jcb;
        private final VisualizationViewer<DrawnEvent, DrawnEventConnection> vv;

        private LayoutChooser(JComboBox jcb, VisualizationViewer<DrawnEvent, DrawnEventConnection> vv) {
            this.jcb = jcb;
            this.vv = vv;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Object[] constructorArgs = new Object[]{BayesianStructureTab.this.graph};
            Class layoutC = (Class)this.jcb.getSelectedItem();
            try {
                Constructor constructor = layoutC.getConstructor(Graph.class);
                Object o = constructor.newInstance(constructorArgs);
                Layout l = (Layout)o;
                l.setInitializer((Function)this.vv.getGraphLayout());
                l.setSize(this.vv.getSize());
                LayoutTransition lt = new LayoutTransition(this.vv, this.vv.getGraphLayout(), l);
                Animator animator = new Animator((IterativeContext)lt);
                animator.start();
                this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                this.vv.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

