/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.training;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.encog.StatusReportable;
import org.encog.mathutil.randomize.Distort;
import org.encog.ml.MLError;
import org.encog.ml.MLMethod;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.persist.EncogDirectoryPersistence;
import org.encog.util.Format;
import org.encog.util.file.FileUtil;
import org.encog.util.validate.ValidateNetwork;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.training.ChartPane;
import org.encog.workbench.tabs.training.TrainingStatusPanel;
import org.encog.workbench.util.EncogFonts;
import org.encog.workbench.util.TimeSpanFormatter;

public class BasicTrainingProgress
extends EncogCommonTab
implements Runnable,
ActionListener,
StatusReportable {
    private final JComboBox comboReset;
    private final JButton buttonStart;
    private final JButton buttonStop;
    private final JButton buttonClose;
    private final JButton buttonIteration;
    private final JPanel panelBody;
    private final JPanel panelButtons;
    private Thread thread;
    private boolean cancel;
    protected TrainingStatusPanel statusPanel;
    protected ChartPane chartPanel;
    private MLTrain train;
    private MLDataSet trainingData;
    private double maxError;
    private int iteration;
    private Font headFont;
    private Font bodyFont;
    private double currentError;
    private double lastError;
    private double errorImprovement;
    private Date started;
    private long lastUpdate;
    private final NumberFormat nf = NumberFormat.getInstance();
    private final NumberFormat nfShort = NumberFormat.getInstance();
    private int performanceCount;
    private Date performanceLast;
    private int performanceLastIteration;
    private String status;
    private boolean shouldExit;
    private AtomicInteger resetOption = new AtomicInteger(-1);
    private boolean error = false;
    private String lastMessage = "";
    private MLDataSet validationData;
    private double validationError;

    public BasicTrainingProgress(MLTrain train, ProjectEGFile method, MLDataSet trainingData, MLDataSet validationData) {
        super(method);
        if (method instanceof MLMethod) {
            ValidateNetwork.validateMethodToData((MLMethod)method.getObject(), trainingData);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("<Select Option>");
        list.add("Reset");
        list.add("Perturb 1%");
        list.add("Perturb 5%");
        list.add("Perturb 10%");
        list.add("Perturb 15%");
        list.add("Perturb 20%");
        list.add("Perturb 50%");
        this.comboReset = new JComboBox<Object>(list.toArray());
        this.validationData = validationData;
        this.train = train;
        this.trainingData = trainingData;
        this.buttonStart = new JButton("Start");
        this.buttonStop = new JButton("Stop");
        this.buttonClose = new JButton("Close");
        this.buttonIteration = new JButton("Iteration");
        this.buttonStart.addActionListener(this);
        this.buttonStop.addActionListener(this);
        this.buttonClose.addActionListener(this);
        this.comboReset.addActionListener(this);
        this.buttonIteration.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.panelBody = new JPanel();
        this.panelButtons = new JPanel();
        this.panelButtons.add(this.buttonStart);
        this.panelButtons.add(this.buttonStop);
        this.panelButtons.add(this.buttonClose);
        this.panelButtons.add(this.buttonIteration);
        this.panelButtons.add(this.comboReset);
        this.add((Component)this.panelBody, "Center");
        this.add((Component)this.panelButtons, "South");
        this.panelBody.setLayout(new BorderLayout());
        this.statusPanel = new TrainingStatusPanel(this);
        this.panelBody.add((Component)this.statusPanel, "North");
        this.chartPanel = new ChartPane(this.validationData != null);
        this.panelBody.add((Component)this.chartPanel, "Center");
        this.buttonStop.setEnabled(false);
        this.shouldExit = false;
        this.bodyFont = EncogFonts.getInstance().getBodyFont();
        this.headFont = EncogFonts.getInstance().getHeadFont();
        this.status = "Ready to Start";
    }

    private void saveMLMethod() {
        ((ProjectEGFile)this.getEncogObject()).save(this.train.getMethod());
        if (this.getParentTab() != null) {
            this.getParentTab().setEncogObject(this.getEncogObject());
            this.getParentTab().refresh();
            this.getParentTab().setDirty(true);
            this.getParentTab().save();
        }
        if (this.train.canContinue()) {
            TrainingContinuation cont = this.train.pause();
            String name = FileUtil.getFileName(this.getEncogObject().getFile());
            name = FileUtil.forceExtension(String.valueOf(name) + "-cont", "eg");
            File path = new File(name);
            EncogWorkBench.getInstance().save(path, cont);
            EncogWorkBench.getInstance().refresh();
        }
    }

    private void performClose() {
        if (this.error) {
            return;
        }
        if (EncogWorkBench.askQuestion("Training", "Save the training?")) {
            if (this.getEncogObject() != null) {
                this.saveMLMethod();
            }
            EncogWorkBench.getInstance().refresh();
        } else if (this.getEncogObject() != null) {
            ((ProjectEGFile)this.getEncogObject()).revert();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonClose) {
            this.dispose();
        } else if (e.getSource() == this.buttonStart) {
            this.performStart();
        } else if (e.getSource() == this.buttonStop) {
            this.performStop();
        } else if (e.getSource() == this.buttonIteration) {
            this.performIteration();
        } else if (e.getSource() == this.comboReset) {
            this.resetOption.set(this.comboReset.getSelectedIndex() - 1);
            this.comboReset.setSelectedIndex(0);
        }
    }

    @Override
    public boolean close() {
        if (this.thread == null) {
            this.performClose();
            return true;
        }
        this.shouldExit = true;
        this.cancel = true;
        return false;
    }

    public MLTrain getTrain() {
        return this.train;
    }

    public MLDataSet getTrainingData() {
        return this.trainingData;
    }

    public void paintStatus(Graphics g) {
        g.setColor(Color.white);
        int width = this.getWidth();
        int height = this.getHeight();
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        g.setFont(this.headFont);
        FontMetrics fm = g.getFontMetrics();
        int y = fm.getHeight();
        g.drawString("Iteration:", 10, y);
        g.drawString("Current Error:", 10, y += fm.getHeight());
        g.drawString("Validation Error:", 10, y += fm.getHeight());
        g.drawString("Error Improvement:", 10, y += fm.getHeight());
        g.drawString("Message:", 10, y += fm.getHeight());
        y = fm.getHeight();
        g.drawString("Elapsed Time:", 400, y);
        g.drawString("Performance:", 400, y += fm.getHeight());
        if (this.train instanceof EvolutionaryAlgorithm) {
            g.drawString("Species Counts:", 400, y += fm.getHeight());
            g.drawString("Best Genome Size:", 400, y += fm.getHeight());
        }
        y = fm.getHeight();
        g.setFont(this.bodyFont);
        String str = this.nf.format(this.iteration);
        str = String.valueOf(str) + " (" + this.status + ")";
        g.drawString(str, 150, y);
        g.drawString(Format.formatPercent(this.currentError), 150, y += fm.getHeight());
        y += fm.getHeight();
        if (this.validationData != null) {
            g.drawString(Format.formatPercent(this.validationError), 150, y);
        } else {
            g.drawString("n/a", 150, y);
        }
        g.drawString(Format.formatPercent(this.errorImprovement), 150, y += fm.getHeight());
        g.drawString(this.lastMessage, 150, y += fm.getHeight());
        y = fm.getHeight();
        long seconds = 0L;
        if (this.started != null) {
            Date now = new Date();
            seconds = (now.getTime() - this.started.getTime()) / 1000L;
        }
        g.drawString(TimeSpanFormatter.formatTime(seconds), 500, y);
        y += fm.getHeight();
        if (this.performanceCount == -1) {
            str = "  (calculating performance)";
        } else {
            double d = (double)this.performanceCount / 60.0;
            str = "  (" + this.nfShort.format(d) + "/sec)";
        }
        g.drawString(str, 500, y);
        if (this.train instanceof EvolutionaryAlgorithm) {
            y += fm.getHeight();
            EvolutionaryAlgorithm ea = (EvolutionaryAlgorithm)((Object)this.train);
            if (ea.getPopulation() != null) {
                g.drawString(Format.formatInteger(ea.getPopulation().getSpecies().size()), 500, y);
                y += fm.getHeight();
                if (ea.getBestGenome() != null) {
                    g.drawString(Format.formatInteger(ea.getBestGenome().size()), 500, y);
                }
            }
        }
    }

    private void performStart() {
        this.performanceLast = this.started = new Date();
        this.performanceCount = -1;
        this.performanceLastIteration = 0;
        this.buttonStart.setEnabled(false);
        this.buttonStop.setEnabled(true);
        this.buttonIteration.setEnabled(false);
        this.cancel = false;
        this.status = "Started";
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void performStop() {
        this.status = "Canceled";
        this.cancel = true;
    }

    public void redraw() {
        this.statusPanel.repaint();
        this.lastUpdate = System.currentTimeMillis();
        this.chartPanel.addData(this.iteration, this.train.getError(), this.errorImprovement, this.validationError);
    }

    @Override
    public void run() {
        try {
            this.startup();
            if (this.train.canContinue()) {
                String name = FileUtil.getFileName(this.getEncogObject().getFile());
                File path = new File(name = String.valueOf(name) + "-cont.eg");
                if (path.exists()) {
                    try {
                        TrainingContinuation cont = (TrainingContinuation)EncogDirectoryPersistence.loadObject(path);
                        this.train.resume(cont);
                    }
                    catch (Exception ex) {
                        EncogWorkBench.displayError("Trainning Resume Incompatible", "Cannot use previous training data, training will begin as best it can.");
                        path.delete();
                    }
                }
            }
            while (!this.cancel) {
                Date now;
                MLMethod m;
                ++this.iteration;
                this.lastError = this.train.getError();
                if (this.resetOption.get() != -1) {
                    MLMethod method = null;
                    if (this.getEncogObject() instanceof ProjectEGFile) {
                        method = (MLMethod)((ProjectEGFile)this.getEncogObject()).getObject();
                    }
                    if (method == null) {
                        this.resetOption.set(-1);
                        EncogWorkBench.displayError("Error", "This machine learning method cannot be reset or randomized.");
                        return;
                    }
                    switch (this.resetOption.get()) {
                        case 0: {
                            if (method instanceof MLResettable) {
                                ((MLResettable)method).reset();
                                break;
                            }
                            EncogWorkBench.displayError("Error", "This Machine Learning method cannot be reset.");
                            break;
                        }
                        case 1: {
                            new Distort(0.01).randomize(method);
                            break;
                        }
                        case 2: {
                            new Distort(0.05).randomize(method);
                            break;
                        }
                        case 3: {
                            new Distort(0.1).randomize(method);
                            break;
                        }
                        case 4: {
                            new Distort(0.15).randomize(method);
                            break;
                        }
                        case 5: {
                            new Distort(0.2).randomize(method);
                            break;
                        }
                        case 6: {
                            new Distort(0.5).randomize(method);
                        }
                    }
                    this.resetOption.set(-1);
                }
                this.train.iteration();
                this.currentError = this.train.getError();
                if (this.currentError < this.maxError) {
                    this.status = "Max Error Reached";
                    this.cancel = true;
                }
                if (this.train.isTrainingDone()) {
                    this.status = "Training Complete";
                    this.cancel = true;
                }
                this.errorImprovement = (this.lastError - this.currentError) / this.lastError;
                if (this.validationData != null && (m = this.train.getMethod()) instanceof MLError) {
                    MLError error = (MLError)m;
                    this.validationError = error.calculateError(this.validationData);
                }
                if (Double.isInfinite(this.errorImprovement) || Double.isNaN(this.errorImprovement)) {
                    this.errorImprovement = 100.0;
                }
                if (System.currentTimeMillis() - this.lastUpdate > 1000L || this.cancel) {
                    this.redraw();
                }
                if ((now = new Date()).getTime() - this.performanceLast.getTime() <= 60000L) continue;
                this.performanceLast = now;
                this.performanceCount = this.iteration - this.performanceLastIteration;
                this.performanceLastIteration = this.iteration;
            }
            this.train.finishTraining();
            this.shutdown();
            this.stopped();
            if (this.shouldExit) {
                this.dispose();
            }
        }
        catch (Throwable t) {
            this.error = true;
            EncogWorkBench.displayError("Error", t, this.getEncogObject(), this.trainingData);
            this.shutdown();
            this.stopped();
            this.dispose();
        }
    }

    public void setMaxError(double maxError) {
        this.maxError = maxError;
    }

    public void setTrain(MLTrain train) {
        this.train = train;
    }

    public void setTrainingData(MLDataSet trainingData) {
        this.trainingData = trainingData;
    }

    public void shutdown() {
    }

    public void startup() {
    }

    private void stopped() {
        this.thread = null;
        this.buttonIteration.setEnabled(true);
        this.buttonStart.setEnabled(true);
        this.buttonStop.setEnabled(false);
        this.cancel = true;
    }

    @Override
    public String getName() {
        return "Training Progress";
    }

    @Override
    public void report(int total, int current, String message) {
        this.lastMessage = message;
        this.redraw();
    }

    public void performIteration() {
        int i = 0;
        while (i < EncogWorkBench.getInstance().getConfig().getIterationStepCount()) {
            MLMethod m;
            ++this.iteration;
            this.lastError = this.train.getError();
            this.train.iteration();
            this.currentError = this.train.getError();
            this.errorImprovement = (this.lastError - this.currentError) / this.lastError;
            if (this.validationData != null && (m = this.train.getMethod()) instanceof MLError) {
                MLError error = (MLError)m;
                this.validationError = error.calculateError(this.validationData);
            }
            if (Double.isInfinite(this.errorImprovement) || Double.isNaN(this.errorImprovement)) {
                this.errorImprovement = 100.0;
            }
            ++i;
        }
        this.redraw();
    }
}

