/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.rbf;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.encog.mathutil.rbf.GaussianFunction;
import org.encog.mathutil.rbf.InverseMultiquadricFunction;
import org.encog.mathutil.rbf.MexicanHatFunction;
import org.encog.mathutil.rbf.MultiquadricFunction;
import org.encog.mathutil.rbf.RadialBasisFunction;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.rbf.RBFFunction2D;
import org.encog.workbench.util.graph.EncogChartPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class RadialBasisFunctionsTab
extends EncogCommonTab
implements ActionListener {
    private static final long serialVersionUID = 4472644832610364833L;
    private JButton buttonClose;
    private RadialBasisFunction rbf;
    private JComboBox typeCombo;
    private ChartPanel chartPanel;

    public RadialBasisFunctionsTab() {
        super((ProjectFile)null);
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "South");
        this.buttonClose = new JButton("Close");
        buttonPanel.add(this.buttonClose);
        this.buttonClose.addActionListener(this);
        double[] center = new double[]{0.0};
        this.rbf = new GaussianFunction(1.0, center, 1.0);
        XYDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        this.chartPanel = new EncogChartPanel(chart);
        this.add((Component)this.chartPanel, "Center");
        this.typeCombo = new JComboBox();
        this.add((Component)this.typeCombo, "North");
        this.typeCombo.addItem(GaussianFunction.class.getSimpleName());
        this.typeCombo.addItem(MultiquadricFunction.class.getSimpleName());
        this.typeCombo.addItem(InverseMultiquadricFunction.class.getSimpleName());
        this.typeCombo.addItem(MexicanHatFunction.class.getSimpleName());
        this.typeCombo.addActionListener(this);
    }

    public JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, (String)"input (x)", (String)"output (y)", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setDomainZeroBaselineVisible(true);
        plot.setRangeZeroBaselineVisible(true);
        plot.setDomainPannable(true);
        plot.setRangePannable(true);
        ValueAxis xAxis = plot.getDomainAxis();
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        XYLineAndShapeRenderer r = (XYLineAndShapeRenderer)plot.getRenderer();
        r.setDrawSeriesLineAsPath(true);
        r.setSeriesStroke(0, (Stroke)new BasicStroke(1.5f));
        r.setSeriesStroke(1, (Stroke)new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{6.0f, 4.0f}, 0.0f));
        r.setSeriesStroke(2, (Stroke)new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{6.0f, 4.0f, 3.0f, 3.0f}, 0.0f));
        r.setSeriesStroke(3, (Stroke)new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{4.0f, 4.0f}, 0.0f));
        return chart;
    }

    public XYDataset createDataset() {
        String title = this.rbf.getClass().getSimpleName();
        XYSeriesCollection dataset = new XYSeriesCollection();
        RBFFunction2D n1 = new RBFFunction2D(this.rbf);
        XYSeries s1 = DatasetUtilities.sampleFunction2DToSeries((Function2D)n1, (double)-5.1, (double)5.1, (int)121, (Comparable)((Object)title));
        dataset.addSeries(s1);
        return dataset;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonClose) {
            this.dispose();
        } else if (e.getSource() == this.typeCombo) {
            int index = this.typeCombo.getSelectedIndex();
            double[] center = new double[]{0.0};
            switch (index) {
                case 0: {
                    this.rbf = new GaussianFunction(1.0, center, 1.0);
                    break;
                }
                case 1: {
                    this.rbf = new MultiquadricFunction(1.0, center, 1.0);
                    break;
                }
                case 2: {
                    this.rbf = new InverseMultiquadricFunction(1.0, center, 1.0);
                    break;
                }
                case 3: {
                    this.rbf = new MexicanHatFunction(1.0, center, 1.0);
                }
            }
            XYDataset dataset = this.createDataset();
            JFreeChart chart = this.createChart(dataset);
            this.chartPanel.setChart(chart);
        }
    }

    @Override
    public String getName() {
        return "RBF";
    }
}

