/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.query.thermal;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import org.encog.ml.data.specific.BiPolarNeuralData;
import org.encog.neural.thermal.BoltzmannMachine;
import org.encog.neural.thermal.HopfieldNetwork;
import org.encog.neural.thermal.ThermalNetwork;
import org.encog.util.EngineArray;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.WorkBenchError;

public class ThermalPanel
extends JPanel
implements MouseListener {
    public ThermalNetwork network;
    private boolean[] grid;
    private int margin;
    private int gridX;
    private int gridY;
    private int cellWidth;
    private int cellHeight;

    public ThermalPanel(ThermalNetwork network) {
        if (network.getProperties().containsKey("rows") && network.getProperties().containsKey("columns")) {
            this.gridX = (int)network.getPropertyLong("columns");
            this.gridY = (int)network.getPropertyLong("rows");
        } else {
            this.gridX = network.getNeuronCount();
            this.gridY = 1;
        }
        this.grid = new boolean[this.gridX * this.gridY];
        if (this.grid.length != network.getNeuronCount()) {
            throw new WorkBenchError("The (rows x columns) must equal the neuron count.");
        }
        this.addMouseListener(this);
        this.network = network;
    }

    public void clear() {
        int index = 0;
        int y = 0;
        while (y < this.gridY) {
            int x = 0;
            while (x < this.gridX) {
                this.grid[index++] = false;
                ++x;
            }
            ++y;
        }
        this.repaint();
    }

    public void clearMatrix() {
        EngineArray.fill(this.network.getWeights(), 0.0);
    }

    public void go() {
        int i = 0;
        while (i < this.grid.length) {
            this.network.getCurrentState().setData(i, this.grid[i]);
            ++i;
        }
        if (this.network instanceof HopfieldNetwork) {
            ((HopfieldNetwork)this.network).run();
        } else {
            ((BoltzmannMachine)this.network).run();
        }
        i = 0;
        while (i < this.grid.length) {
            this.grid[i] = this.network.getCurrentState().getBoolean(i);
            ++i;
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = (e.getX() - this.margin) / this.cellWidth;
        int y = e.getY() / this.cellHeight;
        if (x >= 0 && x < this.gridX && y >= 0 && y < this.gridY) {
            int index = y * this.gridX + x;
            boolean bl = !this.grid[index];
            this.grid[index] = bl;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.cellHeight = height / this.gridY;
        this.cellWidth = width / this.gridX;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        this.margin = (this.getWidth() - this.cellWidth * this.gridX) / 2;
        int index = 0;
        int y = 0;
        while (y < this.gridY) {
            int x = 0;
            while (x < this.gridX) {
                if (this.grid[index++]) {
                    g.fillRect(this.margin + x * this.cellWidth, y * this.cellHeight, this.cellWidth, this.cellHeight);
                } else {
                    g.drawRect(this.margin + x * this.cellWidth, y * this.cellHeight, this.cellWidth, this.cellHeight);
                }
                ++x;
            }
            ++y;
        }
    }

    public void train() {
        if (this.network instanceof BoltzmannMachine) {
            EncogWorkBench.displayError("Error", "Boltzmann machine training is not supported.");
            return;
        }
        BiPolarNeuralData pattern = new BiPolarNeuralData(this.grid.length);
        int i = 0;
        while (i < this.grid.length) {
            pattern.setData(i, this.grid[i]);
            ++i;
        }
        ((HopfieldNetwork)this.network).addPattern(pattern);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }
}

