/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.query.ocr;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.encog.EncogError;
import org.encog.ml.BasicML;
import org.encog.ml.MLClassification;
import org.encog.ml.MLOutput;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.error.ErrorDialog;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.models.NetworkQueryModel;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.query.ocr.DrawingEntry;
import org.encog.workbench.tabs.query.ocr.OCRGridPanel;

public class OCRQueryTab
extends EncogCommonTab
implements ActionListener {
    private BasicML method;
    private OCRGridPanel panel;
    private JPanel buttonPanel;
    private JButton buttonQuery;
    private JButton buttonDownsample;
    private JButton buttonClear;
    private DrawingEntry entry;
    private JTable outputTable;
    private boolean classification;

    public OCRQueryTab(ProjectEGFile file) {
        super(file);
        this.method = (BasicML)file.getObject();
        this.classification = this.method instanceof MLClassification;
        this.setLayout(new BorderLayout());
        JPanel body = new JPanel();
        body.setLayout(new GridLayout(1, 2));
        this.add((Component)body, "Center");
        this.buttonQuery = new JButton("Query");
        this.buttonDownsample = new JButton("Downsample");
        this.buttonClear = new JButton("Clear");
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.buttonQuery);
        this.buttonPanel.add(this.buttonDownsample);
        this.buttonPanel.add(this.buttonClear);
        this.add((Component)this.buttonPanel, "North");
        this.buttonQuery.addActionListener(this);
        this.buttonDownsample.addActionListener(this);
        this.buttonClear.addActionListener(this);
        this.panel = new OCRGridPanel(this.method);
        this.entry = new DrawingEntry();
        JPanel panelLeft = new JPanel();
        JPanel panelRight = new JPanel();
        panelLeft.setLayout(new GridLayout(2, 1));
        panelLeft.add(this.panel);
        panelLeft.add(this.entry);
        panelLeft.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        panelRight.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        body.add(panelLeft);
        body.add(panelRight);
        panelRight.setLayout(new BorderLayout());
        if (this.classification) {
            int outputCount = 1;
            this.outputTable = new JTable(new NetworkQueryModel(outputCount, 2));
            panelRight.add((Component)this.outputTable, "Center");
            this.outputTable.setEnabled(false);
            this.outputTable.setValueAt("Classification Output:", 0, 0);
            this.outputTable.setValueAt("0.0", 0, 1);
        } else {
            int outputCount = ((MLOutput)((Object)this.method)).getOutputCount();
            this.outputTable = new JTable(new NetworkQueryModel(outputCount, 2));
            panelRight.add((Component)this.outputTable, "Center");
            this.outputTable.setEnabled(false);
            int i = 1;
            while (i <= outputCount) {
                this.outputTable.setValueAt("Output " + i + ":", i - 1, 0);
                this.outputTable.setValueAt("0.0", i - 1, 1);
                ++i;
            }
        }
    }

    public void performDownsample() {
        boolean[] data = this.entry.downSample(this.panel.getGridWidth(), this.panel.getGridHeight());
        this.panel.setGrid(data);
    }

    public void performQuery() {
        try {
            int outputCount = ((MLOutput)((Object)this.method)).getOutputCount();
            boolean[] grid = this.panel.getGrid();
            BasicMLData input = new BasicMLData(grid.length);
            int i = 0;
            while (i < grid.length) {
                input.setData(i, grid[i] ? 1 : -1);
                ++i;
            }
            if (this.classification) {
                int output = ((MLClassification)((Object)this.method)).classify(input);
                this.outputTable.setValueAt(output, 0, 1);
            } else {
                MLData output = ((MLRegression)((Object)this.method)).compute(input);
                int i2 = 0;
                while (i2 < outputCount) {
                    this.outputTable.setValueAt(output.getData(i2), i2, 1);
                    ++i2;
                }
            }
        }
        catch (EncogError ex) {
            EncogWorkBench.displayError("Query Error", ex.getMessage());
        }
        catch (Throwable t) {
            ErrorDialog.handleError(t, this.getEncogObject(), null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonClear) {
            this.panel.clear();
            this.entry.clear();
        }
        if (e.getSource() == this.buttonDownsample) {
            this.performDownsample();
        }
        if (e.getSource() == this.buttonQuery) {
            this.performQuery();
        }
    }

    @Override
    public String getName() {
        return "OCR :" + this.getEncogObject().getName();
    }
}

