/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.query.ocr;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.encog.ml.BasicML;
import org.encog.ml.MLInput;
import org.encog.ml.MLMethod;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.WorkBenchError;

public class OCRGridPanel
extends JPanel
implements MouseListener {
    public MLMethod method;
    private boolean[] grid;
    private int margin;
    private int gridX;
    private int gridY;
    private int cellWidth;
    private int cellHeight;

    public OCRGridPanel(BasicML method) {
        if (method.getProperties().containsKey("rows") && method.getProperties().containsKey("columns")) {
            this.gridX = (int)method.getPropertyLong("columns");
            this.gridY = (int)method.getPropertyLong("rows");
        } else if (method instanceof MLInput) {
            this.gridX = ((MLInput)((Object)method)).getInputCount();
            this.gridY = 1;
        } else {
            EncogWorkBench.displayError("Error", "OCR Query cannot be used with this method.");
        }
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.grid = new boolean[this.gridX * this.gridY];
        if (this.grid.length != ((MLInput)((Object)method)).getInputCount()) {
            throw new WorkBenchError("The (rows x columns) must equal the neuron count.");
        }
        this.addMouseListener(this);
        this.method = method;
    }

    public void clear() {
        int index = 0;
        int y = 0;
        while (y < this.gridY) {
            int x = 0;
            while (x < this.gridX) {
                this.grid[index++] = false;
                ++x;
            }
            ++y;
        }
        this.repaint();
    }

    public void clearMatrix() {
    }

    public void go() {
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = (e.getX() - this.margin) / this.cellWidth;
        int y = e.getY() / this.cellHeight;
        if (x >= 0 && x < this.gridX && y >= 0 && y < this.gridY) {
            int index = y * this.gridX + x;
            boolean bl = !this.grid[index];
            this.grid[index] = bl;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        this.cellHeight = height / this.gridY;
        this.cellWidth = width / this.gridX;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        this.margin = (this.getWidth() - this.cellWidth * this.gridX) / 2;
        int index = 0;
        int y = 0;
        while (y < this.gridY) {
            int x = 0;
            while (x < this.gridX) {
                if (this.grid[index++]) {
                    g.fillRect(this.margin + x * this.cellWidth, y * this.cellHeight, this.cellWidth, this.cellHeight);
                } else {
                    g.drawRect(this.margin + x * this.cellWidth, y * this.cellHeight, this.cellWidth, this.cellHeight);
                }
                ++x;
            }
            ++y;
        }
    }

    public void train() {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    public int getGridHeight() {
        return this.gridY;
    }

    public int getGridWidth() {
        return this.gridX;
    }

    public void setGrid(boolean[] data) {
        this.grid = data;
        this.repaint();
    }

    public boolean[] getGrid() {
        return this.grid;
    }
}

