/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.mlmethod;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.networks.BasicNetwork;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.models.WeightsModel;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.mlmethod.MLMethodTab;

public class WeightsTab
extends EncogCommonTab
implements ActionListener,
ItemListener {
    private WeightsModel model;
    private JToolBar toolbar;
    private JTable table;
    private JButton buttonSparse;
    private JComboBox comboView;
    private BasicNetwork network;
    private MLMethodTab owner;

    public WeightsTab(MLMethodTab theOwner, BasicNetwork theNetwork) {
        super((ProjectFile)null);
        this.network = theNetwork;
        this.network.updateProperties();
        this.owner = theOwner;
        this.model = new WeightsModel(this.owner, this.network);
        FlatNetwork flat = theNetwork.getFlat();
        ArrayList<String> layers = new ArrayList<String>();
        int count = flat.getLayerCounts().length - 2;
        String last = "Input";
        int hiddenNo = 1;
        while (count > 0) {
            String current = "Hidden " + hiddenNo;
            layers.add(String.valueOf(last) + " -> " + current);
            last = current;
            ++hiddenNo;
            --count;
        }
        layers.add(String.valueOf(last) + " -> Output");
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.buttonSparse = new JButton("");
        this.toolbar.add(this.buttonSparse);
        this.comboView = new JComboBox<Object>(layers.toArray());
        this.toolbar.add(this.comboView);
        this.add((Component)this.toolbar, "First");
        this.table = new JTable(this.model);
        this.add((Component)new JScrollPane(this.table), "Center");
        this.table.setAutoResizeMode(0);
        this.buttonSparse.addActionListener(this);
        this.comboView.addItemListener(this);
        this.actionPerformed(null);
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action != null && action.getSource() == this.buttonSparse) {
            this.owner.setDirty(true);
            if (this.network.getStructure().isConnectionLimited()) {
                this.network.getProperties().remove("CONNECTION_LIMIT");
                this.network.updateProperties();
            } else {
                this.network.setProperty("CONNECTION_LIMIT", 1.0E-10);
                this.network.updateProperties();
            }
        }
        if (this.network.getStructure().isConnectionLimited()) {
            this.buttonSparse.setText("Disable Sparse Connections");
        } else {
            this.buttonSparse.setText("Enable Sparse Connections");
        }
    }

    @Override
    public boolean close() throws IOException {
        boolean result = super.close();
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public String getName() {
        return "Weights";
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.model.setFromLayer(this.comboView.getSelectedIndex());
        }
    }
}

