/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs.incremental;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.encog.StatusReportable;
import org.encog.ml.data.MLDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.pattern.FeedForwardPattern;
import org.encog.neural.prune.PruneIncremental;
import org.encog.persist.EncogDirectoryPersistence;
import org.encog.util.Format;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.EncogCommonTab;
import org.encog.workbench.tabs.incremental.IncrementalPruneChart;
import org.encog.workbench.tabs.incremental.IncrementalPruneStatusPanel;
import org.encog.workbench.util.EncogFonts;

public class IncrementalPruneTab
extends EncogCommonTab
implements ActionListener,
Runnable,
StatusReportable {
    private final JButton buttonStart;
    private final JButton buttonStop;
    private final JButton buttonClose;
    private final JPanel panelBody;
    private final JPanel panelButtons;
    private Thread thread;
    private boolean cancel;
    private Date started;
    private String status;
    private JPanel statusPanel;
    private JPanel chartPanel;
    private int total;
    private int current;
    private double low;
    private double high;
    private final File path;
    private Font headFont;
    private Font bodyFont;
    private boolean shouldExit;
    private PruneIncremental prune;
    private int iterations;
    private int weightTries;
    private MLDataSet training;
    private FeedForwardPattern pattern;
    private int windowSize;

    public IncrementalPruneTab(int iterations, int weightTries, int windowSize, MLDataSet training, FeedForwardPattern pattern, File path) {
        super((ProjectFile)null);
        this.weightTries = weightTries;
        this.iterations = iterations;
        this.training = training;
        this.pattern = pattern;
        this.windowSize = windowSize;
        this.prune = new PruneIncremental(this.training, this.pattern, this.iterations, this.weightTries, this.windowSize, this);
        this.prune.init();
        this.buttonStart = new JButton("Start");
        this.buttonStop = new JButton("Stop");
        this.buttonClose = new JButton("Close");
        this.buttonStart.addActionListener(this);
        this.buttonStop.addActionListener(this);
        this.buttonClose.addActionListener(this);
        this.path = path;
        this.setLayout(new BorderLayout());
        this.panelBody = new JPanel();
        this.panelButtons = new JPanel();
        this.panelButtons.add(this.buttonStart);
        this.panelButtons.add(this.buttonStop);
        this.panelButtons.add(this.buttonClose);
        this.add((Component)this.panelBody, "Center");
        this.add((Component)this.panelButtons, "South");
        this.panelBody.setLayout(new BorderLayout());
        this.statusPanel = new IncrementalPruneStatusPanel(this);
        this.panelBody.add((Component)this.statusPanel, "North");
        this.chartPanel = new IncrementalPruneChart(this);
        this.panelBody.add((Component)this.chartPanel, "Center");
        this.buttonStop.setEnabled(false);
        this.shouldExit = false;
        this.bodyFont = EncogFonts.getInstance().getBodyFont();
        this.headFont = EncogFonts.getInstance().getHeadFont();
        this.status = "Ready to Start";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonClose) {
            this.dispose();
        } else if (e.getSource() == this.buttonStart) {
            this.performStart();
        } else if (e.getSource() == this.buttonStop) {
            this.performStop();
        }
    }

    private void performStart() {
        this.started = new Date();
        this.buttonStart.setEnabled(false);
        this.buttonStop.setEnabled(true);
        this.cancel = false;
        this.status = "Started";
        this.repaint();
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void performStop() {
        this.buttonStop.setEnabled(false);
        this.status = "Canceled";
        this.cancel = true;
        this.repaint();
        this.prune.stop();
    }

    @Override
    public void run() {
        try {
            this.prune.process();
            this.buttonStart.setEnabled(false);
            this.buttonStop.setEnabled(false);
            this.thread = null;
            if (this.shouldExit) {
                this.dispose();
            }
        }
        catch (Throwable t) {
            EncogWorkBench.displayError("Error", t);
        }
    }

    public void paintStatus(Graphics g) {
        g.setColor(Color.white);
        int width = this.getWidth();
        int height = this.getHeight();
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        g.setFont(this.headFont);
        FontMetrics fm = g.getFontMetrics();
        int y = fm.getHeight();
        g.drawString("Progress:", 10, y);
        g.drawString("Percent Complete:", 10, y += fm.getHeight());
        g.drawString("Status:", 10, y += fm.getHeight());
        y = fm.getHeight();
        g.drawString("High Error:", 250, y);
        g.drawString("Low Error:", 250, y += fm.getHeight());
        y = fm.getHeight();
        g.drawString("Iterations to Try:", 450, y);
        g.drawString("Weights to Try:", 450, y += fm.getHeight());
        g.setFont(this.bodyFont);
        StringBuilder progress = new StringBuilder();
        if (this.total > 0) {
            progress.append(Format.formatInteger(this.current));
            progress.append(" of ");
            progress.append(Format.formatInteger(this.total));
        }
        double percent = 0.0;
        if (this.total > 0) {
            percent = (double)this.current / (double)this.total;
        }
        y = fm.getHeight();
        g.drawString(progress.toString(), 150, y);
        g.drawString(Format.formatPercent(percent), 150, y += fm.getHeight());
        g.drawString(this.status, 150, y += fm.getHeight());
        y = fm.getHeight();
        g.drawString(Format.formatPercent(this.high), 350, y);
        g.drawString(Format.formatPercent(this.low), 350, y += fm.getHeight());
        y = fm.getHeight();
        g.drawString(Format.formatInteger(this.iterations), 550, y);
        g.drawString(Format.formatInteger(this.weightTries), 550, y += fm.getHeight());
    }

    public void paintChart(Graphics g, int width, int height) {
        g.setColor(Color.black);
        this.high = this.prune.getHigh();
        this.low = this.prune.getLow();
        if (this.prune.getHidden1Size() == 0 && this.prune.getHidden2Size() == 0) {
            g.drawString("Chart not supported for more than 2 layers.", 0, 20);
        } else if (this.prune.getHidden1Size() > 0) {
            int blockWidth = this.prune.getHidden2Size() > 0 ? (width - 32) / this.prune.getHidden2Size() : width - 32;
            int blockHeight = (height - 32) / this.prune.getHidden1Size();
            g.setFont(this.headFont);
            g.drawString("H1", 10, height / 2);
            g.drawString("" + this.prune.getHidden().get(0).getMin(), 10, 42);
            if (this.prune.getHidden().size() > 1) {
                g.drawString("H2", width / 2, 15);
                g.drawString("" + this.prune.getHidden().get(1).getMin(), 32, 15);
            }
            int xLimit = Math.max(this.prune.getHidden2Size(), 1);
            int y = 0;
            while (y < this.prune.getHidden1Size()) {
                int x = 0;
                while (x < xLimit) {
                    int xLoc = x * blockWidth;
                    int yLoc = y * blockHeight;
                    double error = this.prune.getResults()[y][x];
                    if (error > 1.0E-5) {
                        this.high = Math.max(this.high, error);
                        this.low = Math.min(this.low, error);
                        double range = this.high - this.low;
                        double p = (error - this.low) / range;
                        int c = (int)(p * 255.0);
                        g.setColor(new Color(c, c, c));
                        g.fillRect(32 + xLoc, 32 + yLoc, blockWidth, blockHeight);
                    } else {
                        g.setColor(Color.black);
                        g.drawRect(32 + xLoc, 32 + yLoc, blockWidth, blockHeight);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    @Override
    public void report(int total, int current, String message) {
        this.total = total;
        this.current = current;
        this.status = message;
        this.repaint();
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public MLDataSet getTraining() {
        return this.training;
    }

    public void setTraining(MLDataSet training) {
        this.training = training;
    }

    public FeedForwardPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(FeedForwardPattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean close() {
        if (this.thread == null) {
            this.performClose();
            return true;
        }
        this.shouldExit = true;
        this.cancel = true;
        return false;
    }

    public void performClose() {
        BasicNetwork network;
        if (this.prune != null && (network = this.prune.getBestNetwork()) != null && EncogWorkBench.askQuestion("Network", "Do you wish to save this network?") && network != null) {
            EncogDirectoryPersistence.saveObject(this.path, (Object)network);
            EncogWorkBench.getInstance().refresh();
        }
    }

    public void addHiddenRange(int low, int high) {
        this.prune.addHiddenLayer(low, high);
        this.prune.init();
        this.repaint();
    }

    public void reportPhase(int arg0, int arg1, String arg2) {
    }

    @Override
    public String getName() {
        return "Prune Progress";
    }
}

