/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.tabs;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.encog.util.Format;
import org.encog.util.HTMLReport;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.tabs.HTMLTab;

public class AboutTab
extends HTMLTab {
    private final List<String> jars = new ArrayList<String>();

    public AboutTab() {
        super((ProjectFile)null);
        this.setPreferredSize(new Dimension(800, 3000));
        String path = System.getProperty("java.class.path");
        StringTokenizer tok = new StringTokenizer(path, "" + File.pathSeparatorChar);
        while (tok.hasMoreTokens()) {
            String jarPath = tok.nextToken();
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) continue;
            try {
                JarFile jarData = new JarFile(jarFile);
                Manifest manifest = jarData.getManifest();
                this.jars.add(String.valueOf(jarFile.getName()) + " (" + jarFile + ")");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.generate();
    }

    public void generate() {
        HTMLReport report = new HTMLReport();
        report.beginHTML();
        String title = "Encog Workbench v3.4";
        report.title(title);
        report.beginBody();
        report.h1(title);
        report.para("Encog Workbench is released under the Apache License.  For more information see the license file released with the Encog Workbench.");
        report.h3("Copyright 2016 by Heaton Research, Inc.");
        report.beginTable();
        report.tablePair("Java Version", System.getProperty("java.version"));
        report.tablePair("Java 64/32-Bit", System.getProperty("sun.arch.data.model"));
        report.tablePair("Processor Count", "" + Runtime.getRuntime().availableProcessors());
        report.tablePair("Default Char Encoding", Charset.defaultCharset().toString());
        report.tablePair("OS Name/Version", ByteOrder.nativeOrder().toString());
        report.tablePair("Encog Core Version", "3.4.0");
        report.tablePair("Available processors (cores): ", "" + Runtime.getRuntime().availableProcessors());
        report.tablePair("Free memory (bytes): ", Format.formatMemory(Runtime.getRuntime().freeMemory()));
        long maxMemory = Runtime.getRuntime().maxMemory();
        report.tablePair("Maximum memory (bytes): ", maxMemory == Long.MAX_VALUE ? "no limit" : Format.formatMemory(maxMemory));
        report.tablePair("Total memory (bytes): ", Format.formatMemory(Runtime.getRuntime().totalMemory()));
        report.endTable();
        report.h3("Active JAR Files");
        report.beginList();
        for (String file : this.jars) {
            report.listItem(file);
        }
        report.endList();
        report.endBody();
        report.endHTML();
        this.display(report.toString());
    }

    @Override
    public String getName() {
        return "About";
    }
}

