/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.encog.neural.networks.BasicNetwork;
import org.encog.workbench.tabs.mlmethod.MLMethodTab;

public class WeightsModel
implements TableModel {
    private BasicNetwork network;
    private int fromLayer = 0;
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private MLMethodTab owner;

    public WeightsModel(MLMethodTab theOwner, BasicNetwork theNetwork) {
        this.network = theNetwork;
        this.owner = theOwner;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return Double.class;
    }

    @Override
    public int getColumnCount() {
        if (this.network == null) {
            return 0;
        }
        return this.network.getLayerNeuronCount(this.fromLayer) + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        String prefix = this.fromLayer == 0 ? "I:" : "H" + this.fromLayer + ":";
        return String.valueOf(prefix) + (columnIndex - 1);
    }

    @Override
    public int getRowCount() {
        if (this.network == null) {
            return 0;
        }
        return this.network.getLayerNeuronCount(this.fromLayer + 1);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.network == null) {
            return 0;
        }
        if (columnIndex == 0) {
            String prefix = this.fromLayer == this.network.getLayerCount() - 2 ? "O:" : "H" + (this.fromLayer + 1) + ":";
            return String.valueOf(prefix) + rowIndex;
        }
        return new Double(this.network.getWeight(this.fromLayer, columnIndex, rowIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.owner.setDirty(true);
        this.network.setWeight(this.fromLayer, columnIndex, rowIndex, (Double)value);
    }

    public int getFromLayer() {
        return this.fromLayer;
    }

    public void setFromLayer(int fromLayer) {
        TableModelEvent tce = new TableModelEvent(this, -1);
        this.fromLayer = fromLayer;
        for (TableModelListener lis : this.listeners) {
            lis.tableChanged(tce);
        }
    }
}

