/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.frames.document.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.encog.util.file.FileUtil;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.document.EncogDocumentFrame;
import org.encog.workbench.frames.document.tree.EncogCollectionModel;
import org.encog.workbench.frames.document.tree.ProjectDirectory;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.frames.document.tree.ProjectItem;
import org.encog.workbench.frames.document.tree.ProjectParent;
import org.encog.workbench.frames.document.tree.ProjectTreeRenderer;
import org.encog.workbench.util.MouseUtil;

public class ProjectTree
extends JPanel
implements MouseListener,
KeyListener,
DropTargetListener {
    private JTree tree;
    private final EncogCollectionModel collectionModel;
    private EncogDocumentFrame doc;
    private DropTarget dt;

    public ProjectTree(EncogDocumentFrame doc) {
        this.doc = doc;
        this.collectionModel = new EncogCollectionModel();
        this.tree = new JTree(this.collectionModel);
        this.tree.addMouseListener(this);
        this.tree.addKeyListener(this);
        this.tree.setCellRenderer(new ProjectTreeRenderer());
        JScrollPane scrollPane = new JScrollPane(this.tree);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.tree.updateUI();
        this.dt = new DropTarget(this, this);
    }

    public List<ProjectItem> getSelectedValue() {
        ArrayList<ProjectItem> result = new ArrayList<ProjectItem>();
        TreePath[] path = this.tree.getSelectionPaths();
        if (path == null || path.length == 0) {
            return null;
        }
        int i = 0;
        while (i < path.length) {
            Object obj = path[i].getLastPathComponent();
            if (obj instanceof ProjectItem) {
                result.add((ProjectItem)obj);
            }
            ++i;
        }
        return result;
    }

    public void rightMouseClicked(MouseEvent e, Object item) {
        if (EncogWorkBench.getInstance().getMainWindow().getTabManager().notWithModalTabOpen()) {
            return;
        }
        this.doc.getPopupMenus().rightMouseClicked(e, item);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (EncogWorkBench.getInstance().getMainWindow().getTabManager().notWithModalTabOpen()) {
            return;
        }
        TreePath path = this.tree.getSelectionPath();
        if (MouseUtil.isRightClick(e)) {
            TreePath[] currentPaths = this.tree.getSelectionPaths();
            TreePath rightPath = this.tree.getClosestPathForLocation(e.getX(), e.getY());
            boolean included = false;
            if (currentPaths != null) {
                TreePath[] treePathArray = currentPaths;
                int n = currentPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath t = treePathArray[n2];
                    if (t.equals(rightPath)) {
                        included = true;
                    }
                    ++n2;
                }
            }
            if (!included) {
                path = rightPath;
                this.tree.setSelectionPath(path);
            }
        }
        if (path != null) {
            File p;
            Object obj = path.getLastPathComponent();
            if (obj instanceof ProjectFile) {
                if (MouseUtil.isRightClick(e)) {
                    this.rightMouseClicked(e, obj);
                } else if (e.getClickCount() == 2) {
                    ProjectFile pf = (ProjectFile)obj;
                    this.doc.openFile(pf);
                }
            } else if (obj instanceof ProjectParent && e.getClickCount() == 2) {
                p = this.collectionModel.getPath().getParentFile();
                EncogWorkBench.getInstance().getMainWindow().changeDirectory(p);
            } else if (obj instanceof ProjectDirectory && e.getClickCount() == 2) {
                p = new File(this.collectionModel.getPath(), obj.toString());
                EncogWorkBench.getInstance().getMainWindow().changeDirectory(p);
            } else if (MouseUtil.isRightClick(e)) {
                this.rightMouseClicked(e, obj);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void refresh() {
        this.collectionModel.invalidate();
    }

    public void refresh(File path) {
        if (path != null) {
            this.collectionModel.invalidate(path);
            EncogWorkBench.getInstance().getMainWindow().redraw();
        }
    }

    public File getPath() {
        return this.collectionModel.getPath();
    }

    public String[] listEGFiles() {
        return this.collectionModel.listEGFiles();
    }

    public ProjectFile findTreeFile(String filename) {
        return this.collectionModel.findTreeFile(filename);
    }

    public EncogCollectionModel getModel() {
        return this.collectionModel;
    }

    @Override
    public void dragEnter(DropTargetDragEvent arg0) {
    }

    @Override
    public void dragExit(DropTargetEvent arg0) {
    }

    @Override
    public void dragOver(DropTargetDragEvent arg0) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (EncogWorkBench.getInstance().getMainWindow().getTabManager().notWithModalTabOpen()) {
            return;
        }
        try {
            if (EncogWorkBench.getInstance().getProjectDirectory() == null) {
                EncogWorkBench.displayError("Error", "Open a project before using drag and drop.");
                return;
            }
            if (!EncogWorkBench.askQuestion("Drag and Drop", "Copy the file(s) to the project?")) {
                return;
            }
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].isFlavorJavaFileListType()) {
                    dtde.acceptDrop(3);
                    List list = (List)tr.getTransferData(flavors[i]);
                    int j = 0;
                    while (j < list.size()) {
                        File sourceFile = new File(list.get(j).toString());
                        if (sourceFile.isDirectory()) {
                            EncogWorkBench.displayError("Drag and Drop", "Can't drop folder.");
                            return;
                        }
                        String name = sourceFile.getName();
                        File targetFile = new File(EncogWorkBench.getInstance().getProjectDirectory(), name);
                        FileUtil.copy(sourceFile, targetFile);
                        ++j;
                    }
                    dtde.dropComplete(true);
                    EncogWorkBench.getInstance().refresh();
                    return;
                }
                ++i;
            }
        }
        catch (Exception e) {
            EncogWorkBench.displayError("Drag and Drop", e);
        }
        dtde.rejectDrop();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (EncogWorkBench.getInstance().getMainWindow().getTabManager().notWithModalTabOpen()) {
            return;
        }
        if (e.getKeyChar() == '\u007f') {
            EncogWorkBench.getInstance().getMainWindow().getOperations().performDelete();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public ProjectFile findTreeFile(File egaFile) {
        return this.collectionModel.findTreeFile(egaFile.getName());
    }

    public ProjectFile findFirstEGA() {
        return this.collectionModel.findFirstEGA();
    }
}

