/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.frames.document.tree;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.encog.persist.EncogDirectoryPersistence;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.frames.document.tree.ProjectDirectory;
import org.encog.workbench.frames.document.tree.ProjectEGFile;
import org.encog.workbench.frames.document.tree.ProjectFile;
import org.encog.workbench.frames.document.tree.ProjectItem;
import org.encog.workbench.frames.document.tree.ProjectParent;
import org.encog.workbench.frames.document.tree.ProjectTraining;
import org.encog.workbench.util.FileUtil;

public class EncogCollectionModel
implements TreeModel {
    private EncogDirectoryPersistence projectDirectory;
    private List<ProjectItem> files = new ArrayList<ProjectItem>();
    private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

    public EncogCollectionModel(File path) {
        this.invalidate(path);
    }

    public EncogCollectionModel() {
    }

    @Override
    public Object getRoot() {
        if (this.projectDirectory == null) {
            return null;
        }
        return this.projectDirectory.getParent();
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.projectDirectory.getParent()) {
            return this.files.get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.projectDirectory.getParent()) {
            return this.files.size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == this.projectDirectory.getParent()) {
            return false;
        }
        if (node instanceof ProjectDirectory) {
            return false;
        }
        if (node instanceof ProjectEGFile) {
            return true;
        }
        if (node instanceof ProjectFile) {
            return true;
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.projectDirectory.getParent()) {
            return this.files.indexOf(child);
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public void invalidate(File path) {
        if (path == null) {
            return;
        }
        try {
            EncogWorkBench.getInstance().getMainWindow().beginWait();
            this.files.clear();
            if (path == null) {
                return;
            }
            this.projectDirectory = new EncogDirectoryPersistence(path);
            TreeSet<File> folderList = new TreeSet<File>();
            TreeSet<File> fileList = new TreeSet<File>();
            if (path.listFiles() != null) {
                File[] fileArray = path.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File entry = fileArray[n2];
                    if (!entry.isHidden()) {
                        if (entry.isDirectory()) {
                            folderList.add(entry);
                        } else {
                            fileList.add(entry);
                        }
                    }
                    ++n2;
                }
            }
            this.files.clear();
            if (path.getParent() != null) {
                this.files.add(new ProjectParent(path.getParentFile()));
            }
            for (File entry : folderList) {
                this.files.add(new ProjectDirectory(entry));
            }
            for (File entry : fileList) {
                String ext = FileUtil.getFileExt(entry);
                if (ext.equalsIgnoreCase("egb")) {
                    this.files.add(new ProjectTraining(entry));
                    continue;
                }
                if (ext.equalsIgnoreCase("eg")) {
                    try {
                        this.files.add(new ProjectEGFile(entry));
                    }
                    catch (Throwable t) {
                        this.files.add(new ProjectFile(entry, true));
                    }
                    continue;
                }
                this.files.add(new ProjectFile(entry));
            }
            Object[] p = new Object[]{this.projectDirectory.getParent()};
            TreeModelEvent e = new TreeModelEvent((Object)this, p);
            for (TreeModelListener l : this.listeners) {
                l.treeStructureChanged(e);
            }
        }
        finally {
            EncogWorkBench.getInstance().getMainWindow().endWait();
        }
    }

    public void invalidate() {
        this.invalidate(this.getPath());
    }

    public File getPath() {
        if (this.projectDirectory == null) {
            return null;
        }
        return this.projectDirectory.getParent();
    }

    public String[] listEGFiles() {
        ArrayList<String> files = new ArrayList<String>();
        for (ProjectItem item : this.files) {
            if (!(item instanceof ProjectEGFile)) continue;
            files.add(((ProjectEGFile)item).getFile().getName());
        }
        String[] result = new String[files.size()];
        files.toArray(result);
        return result;
    }

    public ProjectFile findTreeFile(String filename) {
        for (ProjectItem item : this.files) {
            if (!(item instanceof ProjectFile) || !((ProjectFile)item).getFile().getName().equalsIgnoreCase(filename)) continue;
            return (ProjectFile)item;
        }
        return null;
    }

    public List<ProjectItem> getData() {
        return this.files;
    }

    public EncogDirectoryPersistence getProjectDirectory() {
        return this.projectDirectory;
    }

    public ProjectFile findFirstEGA() {
        for (ProjectItem item : this.files) {
            File file;
            String ext;
            if (!(item instanceof ProjectFile) || !(ext = FileUtil.getFileExt(file = ((ProjectFile)item).getFile())).equalsIgnoreCase("ega")) continue;
            return (ProjectFile)item;
        }
        return null;
    }
}

