/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.frames.document;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.encog.Encog;
import org.encog.workbench.WorkbenchLogging;
import org.encog.workbench.util.EncogFonts;

public class EncogOutputPanel
extends JPanel
implements ActionListener {
    public static final String[] LEVELS = new String[]{"OFF", "CRITICAL", "ERROR", "INFO", "DEBUG"};
    private final JTextArea text = new JTextArea();
    private final JScrollPane scroll;
    private final JButton buttonClear;
    private final JComboBox comboLogLevel;

    public EncogOutputPanel() {
        this.text.setFont(EncogFonts.getInstance().getCodeFont());
        this.text.setEditable(true);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.setLayout(new BorderLayout());
        this.scroll = new JScrollPane(this.text);
        this.add((Component)this.scroll, "Center");
        this.text.setEditable(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        this.add((Component)buttonPanel, "North");
        this.comboLogLevel = new JComboBox<String>(LEVELS);
        buttonPanel.add(new JLabel("Log Level:"));
        buttonPanel.add(this.comboLogLevel);
        this.buttonClear = new JButton("Clear");
        buttonPanel.add(this.buttonClear);
        this.buttonClear.addActionListener(this);
        this.comboLogLevel.addActionListener(this);
    }

    public void output(String output) {
        this.text.append(output);
        int l = this.text.getText().length();
        this.text.setSelectionStart(l);
        this.text.setSelectionEnd(l);
    }

    public void outputLine(String output) {
        this.output(String.valueOf(output) + "\n");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonClear) {
            this.text.setText("");
        } else if (e.getSource() == this.comboLogLevel) {
            String level = (String)this.comboLogLevel.getSelectedItem();
            this.outputLine("Logging level set to: " + level);
            int l = 4;
            if (level.equals("OFF")) {
                l = 4;
            } else if (level.equals("CRITICAL")) {
                l = 3;
            } else if (level.equals("ERROR")) {
                l = 2;
            } else if (level.equals("INFO")) {
                l = 1;
            } else if (level.equals("DEBUG")) {
                l = 0;
            }
            ((WorkbenchLogging)Encog.getInstance().getLoggingPlugin()).setLogLevel(l);
        }
    }

    public JComboBox getComboLogLevel() {
        return this.comboLogLevel;
    }

    public void clear() {
        this.text.setText("");
    }
}

