/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.encog.workbench.WorkBenchError;
import org.encog.workbench.editor.EditorCellEditor;
import org.encog.workbench.editor.PropertyCollection;
import org.encog.workbench.frames.EncogCommonFrame;
import org.encog.workbench.util.MouseUtil;

public class ObjectEditorFrame
extends EncogCommonFrame
implements TreeSelectionListener {
    private Object data;
    private JTable table;
    private JTree tree;
    private JScrollPane scrollTree;
    private JScrollPane scrollTable;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode root;
    private PropertyCollection properties;
    private JPopupMenu popup;
    private JMenuItem popupAdd;
    private JMenuItem popupDelete;

    public ObjectEditorFrame(Object data) {
        this.setSize(400, 400);
        this.setTitle("Editing " + data.getClass().getSimpleName());
        this.data = data;
        this.properties = new PropertyCollection(data);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.root = new DefaultMutableTreeNode(data);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.scrollTable = new JScrollPane();
        this.scrollTree = new JScrollPane(this.tree);
        if (this.containsCollections(data)) {
            content.add((Component)this.scrollTree, "West");
            content.add((Component)this.scrollTable, "East");
        } else {
            content.add((Component)this.scrollTable, "Center");
        }
        this.tree.addTreeSelectionListener(this);
        this.tree.addMouseListener(this);
        this.removeMouseListener(this);
        this.popup = new JPopupMenu();
        this.popupAdd = this.addItem(this.popup, "Add", 97);
        this.popupDelete = this.addItem(this.popup, "Delete", 100);
        this.resetTable();
        this.generateTree();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsCollections(Object obj) {
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            int i = 0;
            while (true) {
                if (i >= fields.length) {
                    return false;
                }
                Field field = fields[i];
                field.setAccessible(true);
                Object fieldObj = field.get(obj);
                if (fieldObj instanceof Collection) {
                    return true;
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            throw new WorkBenchError(e);
        }
        catch (IllegalAccessException e) {
            throw new WorkBenchError(e);
        }
    }

    private void resetTable() {
        this.table = new JTable(this.properties.getModel());
        this.table.getColumnModel().getColumn(1).setCellEditor(new EditorCellEditor());
        this.scrollTable.setViewportView(this.table);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.popupAdd) {
            this.performAdd();
        } else if (e.getSource() == this.popupDelete) {
            this.performDelete();
        }
    }

    public void performDelete() {
        try {
            TreePath path = this.tree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Collection collection = null;
            Object object = null;
            if (node.getUserObject() instanceof String) {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                String fieldName = (String)node.getUserObject();
                Field field = parent.getUserObject().getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                collection = (Collection)field.get(parent.getUserObject());
                object = null;
            } else {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                DefaultMutableTreeNode grandParent = (DefaultMutableTreeNode)parent.getParent();
                String fieldName = (String)parent.getUserObject();
                Field field = grandParent.getUserObject().getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                collection = (Collection)field.get(grandParent.getUserObject());
                object = node.getUserObject();
            }
            if (object == null) {
                collection.clear();
            } else {
                collection.remove(object);
            }
            this.generateTree();
        }
        catch (SecurityException e) {
            throw new WorkBenchError(e);
        }
        catch (IllegalArgumentException e) {
            throw new WorkBenchError(e);
        }
        catch (NoSuchFieldException e) {
            throw new WorkBenchError(e);
        }
        catch (IllegalAccessException e) {
            throw new WorkBenchError(e);
        }
    }

    private void performAdd() {
        try {
            TreePath path = this.tree.getSelectionPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!(node.getUserObject() instanceof String)) {
                node = (DefaultMutableTreeNode)node.getParent();
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            Object obj = parent.getUserObject();
            String fieldName = node.getUserObject().toString();
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object fieldObject = field.get(obj);
            if (fieldObject instanceof Collection) {
                ParameterizedType gtype = (ParameterizedType)field.getGenericType();
                Type[] types = gtype.getActualTypeArguments();
                Object item = ((Class)types[0]).newInstance();
                ((Collection)fieldObject).add(item);
                this.generateTree();
            }
        }
        catch (SecurityException e) {
            throw new WorkBenchError(e);
        }
        catch (NoSuchFieldException e) {
            throw new WorkBenchError(e);
        }
        catch (IllegalAccessException e) {
            throw new WorkBenchError(e);
        }
        catch (InstantiationException e) {
            throw new WorkBenchError(e);
        }
    }

    protected void generateTree() {
        try {
            this.root.removeAllChildren();
            Field[] fields = this.data.getClass().getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                field.setAccessible(true);
                Class<?> c = field.getClass();
                Object value = field.get(this.data);
                if (value instanceof Collection) {
                    DefaultMutableTreeNode n = new DefaultMutableTreeNode(field.getName());
                    this.root.add(n);
                    this.generateTreeCollection(n, (Collection)value);
                }
                ++i;
            }
            this.treeModel.reload();
            this.tree.invalidate();
            TreePath path = new TreePath(this.root);
            this.tree.setSelectionPath(path);
            this.pack();
        }
        catch (IllegalAccessException e) {
            throw new WorkBenchError(e);
        }
    }

    private void generateTreeCollection(DefaultMutableTreeNode parentNode, Collection parentObject) {
        for (Object obj : parentObject) {
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(obj);
            parentNode.add(n);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object obj = n.getUserObject();
            this.resetTable();
            if (obj instanceof String) {
                this.properties.setData(null);
            } else {
                this.properties.setData(obj);
            }
        }
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TreePath path;
        Object obj;
        DefaultMutableTreeNode node;
        TreeNode parent;
        if (MouseUtil.isRightClick(e) && (parent = (node = (DefaultMutableTreeNode)(obj = (path = this.tree.getPathForLocation(e.getX(), e.getY())).getLastPathComponent())).getParent()) != null) {
            this.tree.setSelectionPath(path);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

