/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.training;

import java.io.File;
import java.util.List;
import javax.swing.JComboBox;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.CheckField;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.training.MethodAndTrainingDialog;
import org.encog.workbench.frames.document.tree.ProjectTraining;
import org.encog.workbench.util.FileUtil;

public class TrainDialog
extends MethodAndTrainingDialog {
    private final CheckField loadToMemory;
    private ComboBoxField comboValidation;

    public TrainDialog(boolean includePop) {
        super(includePop);
        this.setSize(600, 250);
        List<ProjectTraining> list = EncogWorkBench.getInstance().getTrainingData("_eval");
        this.comboValidation = new ComboBoxField("validation set", "Validation Set (optional)", false, list);
        this.addProperty(this.comboValidation);
        this.loadToMemory = new CheckField("load to memory", "Load to Memory (better performance)");
        this.addProperty(this.loadToMemory);
        this.render();
        this.loadToMemory.setValue(true);
        this.ensureNonEvalUnselection();
    }

    public CheckField getLoadToMemory() {
        return this.loadToMemory;
    }

    @Override
    public MLDataSet getTrainingSet() {
        if (this.getComboTraining().getSelectedValue() == null) {
            return null;
        }
        File file = ((ProjectTraining)this.getComboTraining().getSelectedValue()).getFile();
        BufferedMLDataSet result = new BufferedMLDataSet(file);
        if (this.loadToMemory.getValue()) {
            return result.loadToMemory();
        }
        return result;
    }

    public MLDataSet getValidationSet() {
        if (this.comboValidation.getSelectedValue() == null) {
            return null;
        }
        File file = ((ProjectTraining)this.comboValidation.getSelectedValue()).getFile();
        BufferedMLDataSet result = new BufferedMLDataSet(file);
        if (this.loadToMemory.getValue()) {
            return result.loadToMemory();
        }
        return result;
    }

    private void ensureNonEvalUnselection() {
        JComboBox comboValidation = (JComboBox)this.comboValidation.getField();
        ProjectTraining selectedItem = (ProjectTraining)comboValidation.getSelectedItem();
        if (selectedItem == null || !FileUtil.getFileName(selectedItem.getFile()).endsWith("_eval")) {
            comboValidation.setSelectedIndex(-1);
        }
    }
}

