/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.splash;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.util.EncogFonts;

public class EncogWorkbenchSplash
extends JDialog
implements ActionListener {
    private JButton buttonNew;
    private JButton buttonOpen;
    private JButton buttonQuit;

    public EncogWorkbenchSplash() {
        this.setLocation(100, 100);
        this.setSize(500, 200);
        this.setModal(true);
        this.setTitle("Welcome");
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3));
        this.buttonNew = new JButton("New Project Folder...");
        buttonPanel.add(this.buttonNew);
        this.buttonOpen = new JButton("Open Project Folder...");
        buttonPanel.add(this.buttonOpen);
        this.buttonQuit = new JButton("Quit");
        buttonPanel.add(this.buttonQuit);
        content.add((Component)buttonPanel, "South");
        this.buttonNew.addActionListener(this);
        this.buttonOpen.addActionListener(this);
        this.buttonQuit.addActionListener(this);
    }

    public void process() {
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonNew) {
            this.dispose();
            EncogWorkBench.getInstance().getMainWindow().getOperations().performFileNewProject();
        } else if (e.getSource() == this.buttonOpen) {
            this.dispose();
            EncogWorkBench.getInstance().getMainWindow().getOperations().performFileChooseDirectory();
        } else if (e.getSource() == this.buttonQuit) {
            this.dispose();
            EncogWorkBench.getInstance().getMainWindow().getOperations().performQuit();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        FontMetrics fm = g.getFontMetrics();
        g.setFont(EncogFonts.getInstance().getTitleFont());
        int y = fm.getHeight() + 30;
        g.setFont(EncogFonts.getInstance().getTitleFont());
        g.drawString("Encog Workbench v3.4", 10, y);
        g.setFont(EncogFonts.getInstance().getBodyFont());
        g.drawString("Copyright 2016 by Heaton Research, Inc.", 10, y += g.getFontMetrics().getHeight());
        g.drawString("Released under the LGPL license", 10, y += g.getFontMetrics().getHeight());
        y += g.getFontMetrics().getHeight();
        g.setFont(EncogFonts.getInstance().getHeadFont());
        g.drawString("Java Version:", 10, y += g.getFontMetrics().getHeight());
        g.setFont(EncogFonts.getInstance().getBodyFont());
        g.drawString(System.getProperty("java.version"), 150, y);
        g.setFont(EncogFonts.getInstance().getHeadFont());
        g.drawString("Java 64/32-Bit:", 10, y += g.getFontMetrics().getHeight());
        g.setFont(EncogFonts.getInstance().getBodyFont());
        g.drawString(System.getProperty("sun.arch.data.model"), 150, y);
        g.setFont(EncogFonts.getInstance().getHeadFont());
        g.drawString("Processor Count:", 10, y += g.getFontMetrics().getHeight());
        g.setFont(EncogFonts.getInstance().getBodyFont());
        g.drawString("" + Runtime.getRuntime().availableProcessors(), 150, y);
        y += g.getFontMetrics().getHeight();
    }
}

