/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.population.neat;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSteepenedSigmoid;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.activation.ActivationDialog;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.IntegerField;
import org.encog.workbench.dialogs.common.PopupField;
import org.encog.workbench.dialogs.common.PopupListener;

public class NewPopulationDialog
extends EncogPropertiesDialog
implements PopupListener {
    private final IntegerField populationSize;
    private final IntegerField inputNeurons;
    private final IntegerField outputNeurons;
    private PopupField neatActivationField;
    private ActivationFunction neatActivationFunction;
    private IntegerField activationCycles;

    public NewPopulationDialog() {
        super(EncogWorkBench.getInstance().getMainWindow());
        this.setSize(500, 300);
        this.setTitle("Create NEAT Population");
        this.populationSize = new IntegerField("population size", "Population Size", true, 1, -1);
        this.addProperty(this.populationSize);
        this.inputNeurons = new IntegerField("input size", "Input Neurons", true, 1, -1);
        this.addProperty(this.inputNeurons);
        this.outputNeurons = new IntegerField("output size", "output Neurons", true, 1, -1);
        this.addProperty(this.outputNeurons);
        this.activationCycles = new IntegerField("cycles", "Cycles", true, 0, 5000);
        this.addProperty(this.activationCycles);
        this.neatActivationField = new PopupField("NEAT activation", "NEAT Activation Function", true);
        this.addProperty(this.neatActivationField);
        this.render();
        this.activationCycles.setValue(1);
        this.setNeatActivationFunction(new ActivationSteepenedSigmoid());
    }

    public IntegerField getPopulationSize() {
        return this.populationSize;
    }

    public IntegerField getInputNeurons() {
        return this.inputNeurons;
    }

    public IntegerField getOutputNeurons() {
        return this.outputNeurons;
    }

    @Override
    public String popup(PopupField field) {
        if (field == this.neatActivationField) {
            ActivationDialog dialog = new ActivationDialog(EncogWorkBench.getInstance().getMainWindow());
            dialog.setActivation(this.neatActivationFunction);
            if (!dialog.process()) {
                return null;
            }
            this.neatActivationFunction = dialog.getActivation();
            return dialog.getActivation().getClass().getSimpleName();
        }
        return null;
    }

    public PopupField getNeatActivationField() {
        return this.neatActivationField;
    }

    public ActivationFunction getNeatActivationFunction() {
        return this.neatActivationFunction;
    }

    public void setNeatActivationFunction(ActivationFunction activationFunction) {
        this.neatActivationFunction = activationFunction;
        this.neatActivationField.setValue(activationFunction.getClass().getSimpleName());
    }

    public IntegerField getActivationCycles() {
        return this.activationCycles;
    }

    public void setActivationCycles(IntegerField activationCycles) {
        this.activationCycles = activationCycles;
    }
}

