/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.newdoc;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.FolderField;
import org.encog.workbench.dialogs.common.InformationField;
import org.encog.workbench.dialogs.common.TextField;

public class CreateNewDocument
extends EncogPropertiesDialog {
    private final FolderField parentDirectory;
    private final TextField projectFilename;

    public CreateNewDocument(Frame owner) {
        super(owner);
        ArrayList<String> list = new ArrayList<String>();
        list.add("CSV");
        this.setSize(640, 200);
        this.setTitle("Create New Encog Project");
        this.parentDirectory = new FolderField("folder", "Parent Folder", true);
        this.addProperty(this.parentDirectory);
        this.projectFilename = new TextField("name", "Project Name", true);
        this.addProperty(this.projectFilename);
        this.addProperty(new InformationField(4, "Encog projects are typically placed in a project folder.  Choose the parent folder, and a name for your project.  A subfolder with the same name as your project will be created.  Your Encog project file will be placed in this folder, along with any training sets you create."));
        this.render();
    }

    public FolderField getParentDirectory() {
        return this.parentDirectory;
    }

    public TextField getProjectFilename() {
        return this.projectFilename;
    }

    @Override
    public boolean passesValidation() {
        File parent = new File(this.parentDirectory.getValue());
        File project = new File(parent, this.projectFilename.getValue());
        return !project.exists() || EncogWorkBench.askQuestion("Exists", "A directory with that project name already exists. \nDo you wish to overwrite it?");
    }
}

