/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.createnetwork;

import java.util.ArrayList;
import org.encog.neural.pnn.PNNKernelType;
import org.encog.neural.pnn.PNNOutputMode;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.IntegerField;

public class CreatePNN
extends EncogPropertiesDialog {
    private static final long serialVersionUID = 1916684369370397010L;
    private IntegerField inputCount;
    private IntegerField outputCount;
    private ComboBoxField kernelType;
    private ComboBoxField outputModel;

    public CreatePNN() {
        super(EncogWorkBench.getInstance().getMainWindow());
        ArrayList<String> outputModelList = new ArrayList<String>();
        outputModelList.add("Regression");
        outputModelList.add("Classification");
        outputModelList.add("Unsupercised");
        ArrayList<String> kernelTypeList = new ArrayList<String>();
        kernelTypeList.add("Gaussian");
        kernelTypeList.add("Reciprocal");
        this.setTitle("Create GRNN/PNN Network");
        this.setSize(400, 400);
        this.setLocation(200, 200);
        this.inputCount = new IntegerField("input neurons", "Input Neuron Count", true, 1, 100000);
        this.addProperty(this.inputCount);
        this.outputCount = new IntegerField("input neurons", "Output Neuron Count", true, 1, 100000);
        this.addProperty(this.outputCount);
        this.kernelType = new ComboBoxField("kernel type", "Kernel Type", true, kernelTypeList);
        this.addProperty(this.kernelType);
        this.outputModel = new ComboBoxField("output model", "Output Model", true, outputModelList);
        this.addProperty(this.outputModel);
        this.render();
    }

    public IntegerField getInputCount() {
        return this.inputCount;
    }

    public IntegerField getOutputCount() {
        return this.outputCount;
    }

    public PNNKernelType getKernelType() {
        switch (this.kernelType.getSelectedIndex()) {
            case 0: {
                return PNNKernelType.Gaussian;
            }
            case 1: {
                return PNNKernelType.Reciprocal;
            }
        }
        return null;
    }

    public PNNOutputMode getOutputModel() {
        switch (this.kernelType.getSelectedIndex()) {
            case 0: {
                return PNNOutputMode.Regression;
            }
            case 1: {
                return PNNOutputMode.Classification;
            }
            case 2: {
                return PNNOutputMode.Unsupervised;
            }
        }
        return null;
    }
}

