/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.common;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.ValidationException;

public abstract class PropertiesField {
    private final String label;
    private final String name;
    private final boolean required;
    private JComponent field;
    private JLabel labelControl;
    private EncogPropertiesDialog owner;

    public PropertiesField(String name, String label, boolean required) {
        this.name = name;
        this.label = label;
        this.required = required;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public JComponent getField() {
        return this.field;
    }

    public void setField(JComponent field) {
        this.field = field;
    }

    public abstract void collect() throws ValidationException;

    public JLabel createLabel() {
        if (this.labelControl != null) {
            return this.labelControl;
        }
        this.labelControl = new JLabel(this.label);
        this.labelControl.setSize(this.labelControl.getPreferredSize());
        return this.labelControl;
    }

    public int createField(JPanel panel, int x, int y, int width) {
        this.field = new JTextField();
        this.field.setLocation(x, y);
        this.field.setSize(this.field.getPreferredSize());
        this.field.setSize(width, this.field.getHeight());
        JLabel label = this.createLabel();
        label.setLocation(label.getX(), y);
        panel.add(label);
        panel.add(this.field);
        return y + this.field.getHeight();
    }

    public EncogPropertiesDialog getOwner() {
        return this.owner;
    }

    public void setOwner(EncogPropertiesDialog owner) {
        this.owner = owner;
    }

    public void enable(boolean e) {
        this.field.setEnabled(e);
    }

    public void setVisable(boolean v) {
        this.field.setVisible(v);
    }

    public void repaint() {
        this.field.repaint();
    }

    public JLabel getLabelControl() {
        return this.labelControl;
    }

    public void setLabelControl(JLabel labelControl) {
        this.labelControl = labelControl;
    }
}

