/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.common;

import javax.swing.JTextField;
import org.encog.workbench.dialogs.common.PropertiesField;
import org.encog.workbench.dialogs.common.ValidationException;

public class IntegerField
extends PropertiesField {
    private final int min;
    private final int max;
    private int value;

    public IntegerField(String name, String label, boolean required, int min, int max) {
        super(name, label, required);
        this.max = max;
        this.min = min;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        ((JTextField)this.getField()).setText("" + value);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public void collect() throws ValidationException {
        int i = 0;
        try {
            i = Integer.parseInt(((JTextField)this.getField()).getText());
        }
        catch (NumberFormatException e) {
            throw new ValidationException("The field " + this.getName() + " requires a valid number.");
        }
        if (this.max > this.min && i < this.min) {
            throw new ValidationException("Must enter a value at or above " + this.min + " for: " + this.getName());
        }
        if (this.max > this.min && i > this.max) {
            throw new ValidationException("Must enter a value below " + this.max + " for: " + this.getName());
        }
        this.value = i;
    }
}

