/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.encog.workbench.dialogs.common.ChartGenerator;
import org.encog.workbench.dialogs.common.ChartListener;
import org.encog.workbench.dialogs.common.PropertiesField;
import org.encog.workbench.dialogs.common.ValidationException;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYDataset;

public class ChartField
extends PropertiesField
implements ActionListener {
    private ChartGenerator generator;
    private int height;
    private JButton refreshButton;
    private ChartListener listener;
    private JPanel chartHolder;

    public ChartField(String name, ChartGenerator generator, int height) {
        super(name, "", true);
        this.generator = generator;
        this.height = height;
    }

    @Override
    public int createField(JPanel panel, int x, int y, int width) {
        this.chartHolder = new JPanel();
        XYDataset dataset = this.generator.createDataset();
        JFreeChart chart = this.generator.createChart(dataset);
        ChartPanel chartPanel = new ChartPanel(chart);
        this.chartHolder.setLayout(new BorderLayout());
        this.chartHolder.add((Component)chartPanel, "Center");
        this.refreshButton = new JButton("Refresh Chart");
        this.chartHolder.add((Component)this.refreshButton, "South");
        this.refreshButton.addActionListener(this);
        this.setField(this.chartHolder);
        this.getField().setLocation(5, y);
        this.getField().setSize(this.getOwner().getWidth() - 5, this.height);
        JLabel label = this.createLabel();
        label.setVisible(false);
        label.setLocation(label.getX(), y);
        panel.add(label);
        panel.add(this.getField());
        return y + this.getField().getHeight();
    }

    @Override
    public void collect() throws ValidationException {
    }

    public ChartListener getListener() {
        return this.listener;
    }

    public void setListener(ChartListener listener) {
        this.listener = listener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.refreshButton && this.listener != null) {
            this.listener.refresh(this);
        }
    }

    public void refresh() {
        this.generator.createDataset();
        this.chartHolder.repaint();
    }
}

