/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs.binary;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.encog.app.analyst.EncogAnalyst;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.dialogs.common.CheckField;
import org.encog.workbench.dialogs.common.ComboBoxField;
import org.encog.workbench.dialogs.common.EncogPropertiesDialog;
import org.encog.workbench.dialogs.common.FileField;
import org.encog.workbench.frames.document.EncogDocumentFrame;
import org.encog.workbench.frames.document.tree.ProjectFile;

public class DialogNormalize2Binary
extends EncogPropertiesDialog {
    private final FileField binaryFile;
    private final FileField externalFile;
    private final ComboBoxField analystFile;
    private final CheckField containsSignificance;
    private List<ProjectFile> analystList;

    public DialogNormalize2Binary() {
        super(EncogWorkBench.getInstance().getMainWindow());
        ArrayList<String> list = new ArrayList<String>();
        list.add("CSV");
        list.add("Excel (*.xlsx)");
        this.analystList = EncogWorkBench.getInstance().getAnalystFiles();
        this.setSize(640, 200);
        this.setTitle("Normalize to Encog Binary Training");
        this.externalFile = new FileField("source file", "Source File", true, false, EncogDocumentFrame.CSV_FILTER);
        this.addProperty(this.externalFile);
        this.binaryFile = new FileField("target file", "Target Encog Binary File(*.egb)", true, true, EncogDocumentFrame.ENCOG_BINARY);
        this.addProperty(this.binaryFile);
        this.analystFile = new ComboBoxField("analyst file", "Analyst File", true, this.analystList);
        this.addProperty(this.analystFile);
        this.containsSignificance = new CheckField("contains significance column", "Significance Column Present");
        this.addProperty(this.containsSignificance);
        this.render();
    }

    public FileField getBinaryFile() {
        return this.binaryFile;
    }

    public FileField getExternalFile() {
        return this.externalFile;
    }

    public final CheckField getContainsSignificance() {
        return this.containsSignificance;
    }

    public EncogAnalyst getAnalyst() {
        if (this.analystFile.getSelectedValue() == null) {
            return null;
        }
        File file = ((ProjectFile)this.analystFile.getSelectedValue()).getFile();
        EncogAnalyst result = new EncogAnalyst();
        result.load(file);
        return result;
    }
}

