/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.encog.StatusReportable;
import org.encog.ml.data.buffer.BinaryDataLoader;
import org.encog.util.Format;
import org.encog.workbench.EncogWorkBench;
import org.encog.workbench.util.TaskComplete;

public class ImportExportDialog
extends JDialog
implements Runnable,
StatusReportable {
    private JProgressBar progress;
    private JLabel status;
    private BinaryDataLoader loader;
    private File binaryFile;
    private boolean performImport;
    private TaskComplete done;

    public ImportExportDialog(BinaryDataLoader loader, File binaryFile, boolean performImport) {
        this.loader = loader;
        this.binaryFile = binaryFile;
        this.performImport = performImport;
        this.progress = new JProgressBar(0, 100);
        if (performImport) {
            this.setTitle("Please wait...importing...");
        } else {
            this.setTitle("Please wait...exporting...");
        }
        this.setSize(640, 75);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        this.status = new JLabel("");
        content.add((Component)this.status, "Center");
        content.add((Component)this.progress, "South");
    }

    public void process(TaskComplete done) {
        this.done = done;
        this.setVisible(true);
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        try {
            try {
                this.loader.setStatus(this);
                if (this.performImport) {
                    this.loader.external2Binary(this.binaryFile);
                } else {
                    this.loader.binary2External(this.binaryFile);
                }
                this.dispose();
                EncogWorkBench.displayMessage("Done", "Done");
                if (this.done != null) {
                    this.done.complete();
                }
            }
            catch (Throwable t) {
                EncogWorkBench.displayError("Error", t);
                EncogWorkBench.getInstance().getMainWindow().getTree().refresh();
            }
        }
        finally {
            EncogWorkBench.getInstance().getMainWindow().getTree().refresh();
        }
    }

    @Override
    public void report(int total, int current, String status) {
        StringBuilder result = new StringBuilder();
        if (total > 0) {
            double percent = (double)current / (double)total;
            int value = (int)(100.0 * percent);
            this.progress.setValue(value);
            result.append(Format.formatInteger(current));
            result.append(" / ");
            result.append(Format.formatInteger(total));
            result.append(": ");
        } else {
            result.append(Format.formatInteger(current));
            result.append(": ");
            this.progress.setValue(0);
        }
        result.append(status);
        this.status.setText(result.toString());
    }

    public void reportPhase(int arg0, int arg1, String arg2) {
    }
}

