/*
 * Decompiled with CFR 0.152.
 */
package org.encog.workbench.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.encog.mathutil.error.ErrorCalculationMode;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.persist.PersistError;
import org.encog.workbench.EncogWorkBench;

public class EncogWorkBenchConfig {
    public static final String PROPERTY_DEFAULT_ERROR = "defaultError";
    public static final String PROPERTY_THREAD_COUNT = "threadCount";
    public static final String PROPERTY_USE_GPU = "useGPU";
    public static final String PROPERTY_ERROR_CALC = "errorCalculation";
    private static final String PROPERTY_STEP_COUNT = "stepCount";
    private static final String PROPERTY_TRAINING_HISTORY = "trainingHistory";
    private static final String PROPERTY_TRAINING_IMPROVEMENT = "trainingImprovement";
    private static final String PROPERTY_CLOUD_SERVER_PORT = "serverPort";
    private static final String PROPERTY_CLOUD_ALLOW_CONNECTIONS = "allowConnections";
    private static final String PROPERTY_PROJECT_ROOT = "allowConnections";
    private static final String PROPERTY_LOG_LEVEL = "logLevel";
    private double defaultError;
    private int threadCount;
    private boolean useOpenCL;
    private int errorCalculation;
    private int iterationStepCount;
    private int trainingHistory;
    private boolean showTrainingImprovement;
    private String projectRoot;

    public EncogWorkBenchConfig() {
        this.resetDefaults();
    }

    public double getDefaultError() {
        return this.defaultError;
    }

    public void setDefaultError(double defaultError) {
        this.defaultError = defaultError;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean isUseOpenCL() {
        return this.useOpenCL;
    }

    public void setUseOpenCL(boolean useOpenCL) {
        this.useOpenCL = useOpenCL;
    }

    public ErrorCalculationMode getErrorCalculation() {
        switch (this.errorCalculation) {
            case 1: {
                return ErrorCalculationMode.RMS;
            }
            case 0: {
                return ErrorCalculationMode.MSE;
            }
        }
        return ErrorCalculationMode.MSE;
    }

    public void setErrorCalculation(ErrorCalculationMode errorCalculation) {
        switch (errorCalculation) {
            case RMS: {
                this.errorCalculation = 1;
                break;
            }
            case MSE: {
                this.errorCalculation = 0;
            }
        }
    }

    public int getIterationStepCount() {
        return this.iterationStepCount;
    }

    public void setIterationStepCount(int iterationStepCount) {
        this.iterationStepCount = iterationStepCount;
    }

    public int getTrainingHistory() {
        return this.trainingHistory;
    }

    public void setTrainingHistory(int trainingHistory) {
        this.trainingHistory = trainingHistory;
    }

    public boolean isShowTrainingImprovement() {
        return this.showTrainingImprovement;
    }

    public void setShowTrainingImprovement(boolean showTrainingImprovement) {
        this.showTrainingImprovement = showTrainingImprovement;
    }

    public void saveConfig() {
        block2: {
            File file = null;
            try {
                String home = System.getProperty("user.home");
                file = new File(home, ".EncogWorkbench.conf");
                FileOutputStream os = new FileOutputStream(file);
                EncogWriteHelper out = new EncogWriteHelper(os);
                out.addSection("ENCOG");
                out.addSubSection("TRAINING");
                out.writeProperty(PROPERTY_DEFAULT_ERROR, this.defaultError);
                out.writeProperty(PROPERTY_THREAD_COUNT, this.threadCount);
                out.writeProperty(PROPERTY_USE_GPU, this.useOpenCL);
                out.writeProperty(PROPERTY_ERROR_CALC, this.errorCalculation);
                out.writeProperty(PROPERTY_STEP_COUNT, this.iterationStepCount);
                out.writeProperty(PROPERTY_TRAINING_HISTORY, this.trainingHistory);
                out.writeProperty(PROPERTY_TRAINING_IMPROVEMENT, this.showTrainingImprovement);
                out.writeProperty(PROPERTY_LOG_LEVEL, this.getLogLevel());
                out.addSubSection("PATHS");
                out.writeProperty("allowConnections", this.projectRoot);
                out.flush();
                ((OutputStream)os).close();
            }
            catch (IOException ex) {
                if (file == null) break block2;
                EncogWorkBench.displayError("Can't write config file", file.toString());
            }
        }
    }

    public void loadConfig() {
        String home = System.getProperty("user.home");
        File f = new File(home, ".EncogWorkbench.conf");
        if (!f.exists()) {
            return;
        }
        try {
            EncogFileSection section;
            File file = new File(home, ".EncogWorkbench.conf");
            FileInputStream is = new FileInputStream(file);
            EncogReadHelper in = new EncogReadHelper(is);
            while ((section = in.readNextSection()) != null) {
                Map<String, String> params;
                if (section.getSectionName().equals("ENCOG") && section.getSubSectionName().equals("TRAINING")) {
                    params = section.parseParams();
                    try {
                        this.defaultError = EncogFileSection.parseDouble(params, PROPERTY_DEFAULT_ERROR);
                        this.threadCount = EncogFileSection.parseInt(params, PROPERTY_THREAD_COUNT);
                        this.useOpenCL = EncogFileSection.parseInt(params, PROPERTY_THREAD_COUNT) > 0;
                        this.errorCalculation = EncogFileSection.parseInt(params, PROPERTY_ERROR_CALC);
                        this.iterationStepCount = EncogFileSection.parseInt(params, PROPERTY_STEP_COUNT);
                        this.trainingHistory = EncogFileSection.parseInt(params, PROPERTY_TRAINING_HISTORY);
                        this.setLogLevel(EncogFileSection.parseInt(params, PROPERTY_LOG_LEVEL));
                        this.showTrainingImprovement = EncogFileSection.parseBoolean(params, PROPERTY_TRAINING_IMPROVEMENT);
                    }
                    catch (PersistError e) {
                        this.resetDefaults();
                    }
                    continue;
                }
                if (!section.getSectionName().equals("ENCOG") || !section.getSubSectionName().equals("PATHS")) continue;
                params = section.parseParams();
                if (params.containsKey("allowConnections")) {
                    this.projectRoot = params.get("allowConnections");
                }
                if (this.projectRoot != null && this.projectRoot.trim().length() != 0) continue;
                this.projectRoot = EncogWorkBenchConfig.getDefaultProjectRoot().toString();
            }
            ((InputStream)is).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetDefaults() {
        this.defaultError = 1.0;
        this.threadCount = 0;
        this.useOpenCL = false;
        this.errorCalculation = 0;
        this.iterationStepCount = 1;
        this.trainingHistory = 100;
        this.showTrainingImprovement = true;
        this.projectRoot = EncogWorkBenchConfig.getDefaultProjectRoot().toString();
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    public static File getDefaultProjectRoot() {
        String home = System.getProperty("user.home");
        File encogFolders = new File(home, "EncogProjects");
        encogFolders.mkdir();
        return encogFolders;
    }

    public int getLogLevel() {
        int index = EncogWorkBench.getInstance().getMainWindow().getOutputPane().getComboLogLevel().getSelectedIndex();
        return index;
    }

    public void setLogLevel(int logLevel) {
        EncogWorkBench.getInstance().getMainWindow().getOutputPane().getComboLogLevel().setSelectedIndex(logLevel);
    }
}

