/*
 * Decompiled with CFR 0.152.
 */
package org.encog.visualize;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.structure.AnalyzeNetwork;
import org.encog.workbench.frames.EncogCommonFrame;
import org.encog.workbench.tabs.visualize.weights.WeightInfo;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class NetworkWeightsFrame
extends EncogCommonFrame {
    private static final long serialVersionUID = 1L;
    private JButton buttonClose;
    private JTabbedPane tabs;
    private WeightInfo weightInfo;
    private AnalyzeNetwork analyze;
    private BasicNetwork network;
    private HistogramDataset dataAll;
    private HistogramDataset dataWeights;
    private HistogramDataset dataBiases;

    public NetworkWeightsFrame(BasicNetwork network) {
        this.network = network;
        this.addWindowListener(this);
        this.setTitle("Visualize Weights");
        this.getContentPane().add((Component)this.setPannels(), "Center");
        this.setSize(520, 500);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private JPanel setPannels() {
        JPanel main = new JPanel();
        this.analyze = new AnalyzeNetwork(this.network);
        System.out.println("Debug network=\n" + this.analyze.toString());
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        main.add((Component)buttonPanel, "South");
        this.buttonClose = new JButton("Close");
        buttonPanel.add(this.buttonClose);
        this.buttonClose.addActionListener(this);
        this.createAllDataset();
        ChartPanel allChart = new ChartPanel(this.createChart((IntervalXYDataset)this.dataAll));
        ChartPanel weightChart = new ChartPanel(this.createChart((IntervalXYDataset)this.dataWeights));
        ChartPanel biasesChart = new ChartPanel(this.createChart((IntervalXYDataset)this.dataBiases));
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Weights & Biases", (Component)allChart);
        this.tabs.addTab("Weights", (Component)weightChart);
        this.tabs.addTab("Biases", (Component)biasesChart);
        main.add((Component)this.tabs, "Center");
        return main;
    }

    private void createAllDataset() {
        this.dataAll = new HistogramDataset();
        double[] values = this.analyze.getAllValues();
        if (values != null && values.length > 0) {
            this.dataAll.addSeries((Comparable)((Object)"Weights & Biases"), values, 50);
        }
        this.dataBiases = new HistogramDataset();
        double[] values2 = this.analyze.getWeightValues();
        if (values2 != null && values2.length > 0) {
            this.dataBiases.addSeries((Comparable)((Object)"Biases"), values2, 50);
        }
        this.dataWeights = new HistogramDataset();
        double[] values3 = this.analyze.getBiasValues();
        if (values3 != null && values3.length > 0) {
            this.dataWeights.addSeries((Comparable)((Object)"Weights"), values3, 50);
        }
    }

    private JFreeChart createChart(IntervalXYDataset dataset) {
        JFreeChart chart = ChartFactory.createHistogram(null, null, null, (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.getXYPlot().setForegroundAlpha(0.75f);
        return chart;
    }

    public AnalyzeNetwork getAnalyze() {
        return this.analyze;
    }

    @Override
    public String getName() {
        return "Visualize Weights";
    }
}

