/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.csv;

import java.util.ArrayList;
import java.util.List;
import org.encog.util.SimpleParser;
import org.encog.util.csv.CSVFormat;

public class ParseCSVLine {
    private CSVFormat format;

    public ParseCSVLine(CSVFormat theFormat) {
        this.format = theFormat;
    }

    public List<String> parse(String line) {
        if (this.format.getSeparator() == ' ') {
            return this.parseSpaceSep(line);
        }
        return this.parseCharSep(line);
    }

    private List<String> parseSpaceSep(String line) {
        ArrayList<String> result = new ArrayList<String>();
        SimpleParser parse = new SimpleParser(line);
        while (!parse.eol()) {
            if (parse.peek() == '\"') {
                result.add(parse.readQuotedString());
            } else {
                result.add(parse.readToWhiteSpace());
            }
            parse.eatWhiteSpace();
        }
        return result;
    }

    private List<String> parseCharSep(String line) {
        StringBuilder item = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        boolean quoted = false;
        boolean hadQuotes = false;
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (ch == this.format.getSeparator() && !quoted) {
                String s = item.toString();
                if (!hadQuotes) {
                    s = s.trim();
                }
                result.add(s);
                item.setLength(0);
                quoted = false;
                hadQuotes = false;
            } else if (ch == '\"' && quoted) {
                if (i + 1 < line.length() && line.charAt(i + 1) == '\"') {
                    ++i;
                    item.append("\"");
                } else {
                    quoted = false;
                }
            } else if (ch == '\"' && item.length() == 0) {
                hadQuotes = true;
                quoted = true;
            } else {
                item.append(ch);
            }
            ++i;
        }
        if (item.length() > 0) {
            String s = item.toString();
            if (!hadQuotes) {
                s = s.trim();
            }
            result.add(s);
        }
        return result;
    }
}

