/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.benchmark;

import org.encog.mathutil.randomize.generate.LinearCongruentialRandom;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;

public final class RandomTrainingFactory {
    public static BasicMLDataSet generate(long seed, int count, int inputCount, int idealCount, double min, double max) {
        LinearCongruentialRandom rand = new LinearCongruentialRandom(seed);
        BasicMLDataSet result = new BasicMLDataSet();
        int i = 0;
        while (i < count) {
            BasicMLData inputData = new BasicMLData(inputCount);
            int j = 0;
            while (j < inputCount) {
                inputData.setData(j, rand.nextDouble(min, max));
                ++j;
            }
            BasicMLData idealData = new BasicMLData(idealCount);
            int j2 = 0;
            while (j2 < idealCount) {
                idealData.setData(j2, rand.nextDouble(min, max));
                ++j2;
            }
            BasicMLDataPair pair = new BasicMLDataPair(inputData, idealData);
            result.add(pair);
            ++i;
        }
        return result;
    }

    public static void generate(MLDataSet training, long seed, int count, double min, double max) {
        LinearCongruentialRandom rand = new LinearCongruentialRandom(seed);
        int inputCount = training.getInputSize();
        int idealCount = training.getIdealSize();
        int i = 0;
        while (i < count) {
            BasicMLData inputData = new BasicMLData(inputCount);
            int j = 0;
            while (j < inputCount) {
                inputData.setData(j, rand.nextDouble(min, max));
                ++j;
            }
            BasicMLData idealData = new BasicMLData(idealCount);
            int j2 = 0;
            while (j2 < idealCount) {
                idealData.setData(j2, rand.nextDouble(min, max));
                ++j2;
            }
            BasicMLDataPair pair = new BasicMLDataPair(inputData, idealData);
            training.add(pair);
            ++i;
        }
    }

    private RandomTrainingFactory() {
    }
}

