/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.arrayutil;

import java.util.ArrayList;
import java.util.List;

public class WindowDouble {
    private int size;
    private List<double[]> data = new ArrayList<double[]>();

    public WindowDouble(int theSize) {
        this.size = theSize;
    }

    public void add(double[] a) {
        this.data.add(0, a);
        while (this.data.size() > this.size) {
            this.data.remove(this.data.size() - 1);
        }
    }

    public void clear() {
        this.data.clear();
    }

    public boolean isFull() {
        return this.data.size() == this.size;
    }

    public double calculateMax(int index, int starting) {
        double result = Double.NEGATIVE_INFINITY;
        int i = starting;
        while (i < this.data.size()) {
            double[] a = this.data.get(i);
            result = Math.max(a[index], result);
            ++i;
        }
        return result;
    }

    public double calculateMin(int index, int starting) {
        double result = Double.POSITIVE_INFINITY;
        int i = starting;
        while (i < this.data.size()) {
            double[] a = this.data.get(i);
            result = Math.min(a[index], result);
            ++i;
        }
        return result;
    }

    public double[] getLast() {
        return this.data.get(0);
    }
}

