/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.arrayutil;

import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.util.arrayutil.TemporalType;
import org.encog.util.arrayutil.TemporalWindowField;

public class TemporalWindowArray {
    private int inputWindow;
    private int predictWindow;
    private TemporalWindowField[] fields;

    public TemporalWindowArray(int theInputWindow, int thePredictWindow) {
        this.inputWindow = theInputWindow;
        this.predictWindow = thePredictWindow;
    }

    public final void analyze(double[] array) {
        this.fields = new TemporalWindowField[1];
        this.fields[0] = new TemporalWindowField("0");
        this.fields[0].setAction(TemporalType.InputAndPredict);
    }

    public final void analyze(double[][] array) {
        int length = array[0].length;
        this.fields = new TemporalWindowField[length];
        int i = 0;
        while (i < length) {
            this.fields[i] = new TemporalWindowField("" + i);
            this.fields[i].setAction(TemporalType.InputAndPredict);
            ++i;
        }
    }

    public final int countInputFields() {
        int result = 0;
        TemporalWindowField[] temporalWindowFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            TemporalWindowField field = temporalWindowFieldArray[n2];
            if (field.getInput()) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    public final int countPredictFields() {
        int result = 0;
        TemporalWindowField[] temporalWindowFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            TemporalWindowField field = temporalWindowFieldArray[n2];
            if (field.getPredict()) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    public final TemporalWindowField[] getFields() {
        return this.fields;
    }

    public final int getInputWindow() {
        return this.inputWindow;
    }

    public final int getPredictWindow() {
        return this.predictWindow;
    }

    public final MLDataSet process(double[] data) {
        BasicMLDataSet result = new BasicMLDataSet();
        int totalWindowSize = this.inputWindow + this.predictWindow;
        int stopPoint = data.length - totalWindowSize;
        int i = 0;
        while (i < stopPoint) {
            BasicMLData inputData = new BasicMLData(this.inputWindow);
            BasicMLData idealData = new BasicMLData(this.predictWindow);
            int index = i;
            int j = 0;
            while (j < this.inputWindow) {
                inputData.setData(j, data[index++]);
                ++j;
            }
            j = 0;
            while (j < this.predictWindow) {
                idealData.setData(j, data[index++]);
                ++j;
            }
            BasicMLDataPair pair = new BasicMLDataPair(inputData, idealData);
            result.add(pair);
            ++i;
        }
        return result;
    }

    public final void setInputWindow(int theInputWindow) {
        this.inputWindow = theInputWindow;
    }

    public final void setPredictWindow(int thePredictWindow) {
        this.predictWindow = thePredictWindow;
    }

    public MLDataSet process(double[][] data) {
        BasicMLDataSet result = new BasicMLDataSet();
        double[][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[] doubles = dArray[n2];
            result.add(this.processToPair(doubles));
            ++n2;
        }
        return result;
    }

    public MLDataPair processToPair(double[] data) {
        BasicMLDataPair pair = null;
        int totalWindowSize = this.inputWindow + this.predictWindow;
        int stopPoint = data.length - totalWindowSize;
        int i = 0;
        while (i < stopPoint) {
            BasicMLData inputData = new BasicMLData(this.inputWindow);
            BasicMLData idealData = new BasicMLData(this.predictWindow);
            int index = i;
            int j = 0;
            while (j < this.inputWindow) {
                inputData.setData(j, data[index++]);
                ++j;
            }
            j = 0;
            while (j < this.predictWindow) {
                idealData.setData(j, data[index++]);
                ++j;
            }
            pair = new BasicMLDataPair(inputData, idealData);
            ++i;
        }
        return pair;
    }
}

