/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.thermal;

import org.encog.ml.BasicML;
import org.encog.ml.MLAutoAssocation;
import org.encog.ml.MLMethod;
import org.encog.ml.MLResettable;
import org.encog.ml.data.specific.BiPolarNeuralData;
import org.encog.neural.NeuralNetworkError;
import org.encog.util.EngineArray;

public abstract class ThermalNetwork
extends BasicML
implements MLMethod,
MLAutoAssocation,
MLResettable {
    private static final long serialVersionUID = 1L;
    private BiPolarNeuralData currentState;
    private double[] weights;
    private int neuronCount;

    public ThermalNetwork() {
    }

    public ThermalNetwork(int neuronCount) {
        this.neuronCount = neuronCount;
        this.weights = new double[neuronCount * neuronCount];
        this.currentState = new BiPolarNeuralData(neuronCount);
    }

    public void addWeight(int fromNeuron, int toNeuron, double value) {
        int index = toNeuron * this.neuronCount + fromNeuron;
        if (index >= this.weights.length) {
            throw new NeuralNetworkError("Out of range: fromNeuron:" + fromNeuron + ", toNeuron: " + toNeuron);
        }
        int n = index;
        this.weights[n] = this.weights[n] + value;
    }

    public double calculateEnergy() {
        double tempE = 0.0;
        int neuronCount = this.getNeuronCount();
        int i = 0;
        while (i < neuronCount) {
            int j = 0;
            while (j < neuronCount) {
                if (i != j) {
                    tempE += this.getWeight(i, j) * this.currentState.getData(i) * this.currentState.getData(j);
                }
                ++j;
            }
            ++i;
        }
        return -1.0 * tempE / 2.0;
    }

    public void clear() {
        EngineArray.fill(this.weights, 0.0);
    }

    public BiPolarNeuralData getCurrentState() {
        return this.currentState;
    }

    public int getNeuronCount() {
        return this.neuronCount;
    }

    public double getWeight(int fromNeuron, int toNeuron) {
        int index = toNeuron * this.neuronCount + fromNeuron;
        return this.weights[index];
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void init(int neuronCount, double[] weights, double[] output) {
        if (neuronCount != output.length) {
            throw new NeuralNetworkError("Neuron count(" + neuronCount + ") must match output count(" + output.length + ").");
        }
        if (neuronCount * neuronCount != weights.length) {
            throw new NeuralNetworkError("Weight count(" + weights.length + ") must be the square of the neuron count(" + neuronCount + ").");
        }
        this.neuronCount = neuronCount;
        this.weights = weights;
        this.currentState = new BiPolarNeuralData(neuronCount);
        this.currentState.setData(output);
    }

    @Override
    public void reset() {
        this.reset(0);
    }

    @Override
    public void reset(int seed) {
        this.getCurrentState().clear();
        EngineArray.fill(this.weights, 0.0);
    }

    public void setCurrentState(BiPolarNeuralData state) {
        int i = 0;
        while (i < state.size()) {
            this.currentState.setData(i, state.getData(i));
            ++i;
        }
    }

    public void setCurrentState(double[] s) {
        this.currentState = new BiPolarNeuralData(s.length);
        EngineArray.arrayCopy(s, this.currentState.getData());
    }

    public void setNeuronCount(int c) {
        this.neuronCount = c;
    }

    public void setWeight(int fromNeuron, int toNeuron, double value) {
        int index = toNeuron * this.neuronCount + fromNeuron;
        this.weights[index] = value;
    }

    public void setWeights(double[] w) {
        this.weights = w;
    }
}

