/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pnn;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.neural.pnn.BasicPNN;
import org.encog.neural.pnn.PNNKernelType;
import org.encog.neural.pnn.PNNOutputMode;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.util.EngineArray;
import org.encog.util.csv.CSVFormat;

public class PersistBasicPNN
implements EncogPersistor {
    public static final String PROPERTY_outputMode = "outputMode";

    public static String kernelToString(PNNKernelType k) {
        switch (k) {
            case Gaussian: {
                return "gaussian";
            }
            case Reciprocal: {
                return "reciprocal";
            }
        }
        return null;
    }

    public static String outputModeToString(PNNOutputMode mode) {
        switch (mode) {
            case Regression: {
                return "regression";
            }
            case Unsupervised: {
                return "unsupervised";
            }
            case Classification: {
                return "classification";
            }
        }
        return null;
    }

    public static PNNKernelType stringToKernel(String k) {
        if (k.equalsIgnoreCase("gaussian")) {
            return PNNKernelType.Gaussian;
        }
        if (k.equalsIgnoreCase("reciprocal")) {
            return PNNKernelType.Reciprocal;
        }
        return null;
    }

    public static PNNOutputMode stringToOutputMode(String mode) {
        if (mode.equalsIgnoreCase("regression")) {
            return PNNOutputMode.Regression;
        }
        if (mode.equalsIgnoreCase("unsupervised")) {
            return PNNOutputMode.Unsupervised;
        }
        if (mode.equalsIgnoreCase("classification")) {
            return PNNOutputMode.Classification;
        }
        return null;
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getPersistClassString() {
        return "BasicPNN";
    }

    @Override
    public Object read(InputStream is) {
        EncogFileSection section;
        EncogReadHelper in = new EncogReadHelper(is);
        BasicMLDataSet samples = new BasicMLDataSet();
        Map<String, String> networkParams = null;
        PNNKernelType kernel = null;
        PNNOutputMode outmodel = null;
        int inputCount = 0;
        int outputCount = 0;
        double error = 0.0;
        double[] sigma = null;
        while ((section = in.readNextSection()) != null) {
            if (section.getSectionName().equals("PNN") && section.getSubSectionName().equals("PARAMS")) {
                networkParams = section.parseParams();
            }
            if (section.getSectionName().equals("PNN") && section.getSubSectionName().equals("NETWORK")) {
                Map<String, String> params = section.parseParams();
                inputCount = EncogFileSection.parseInt(params, "inputCount");
                outputCount = EncogFileSection.parseInt(params, "outputCount");
                kernel = PersistBasicPNN.stringToKernel(params.get("kernel"));
                outmodel = PersistBasicPNN.stringToOutputMode(params.get(PROPERTY_outputMode));
                error = EncogFileSection.parseDouble(params, "error");
                sigma = section.parseDoubleArray(params, "sigma");
            }
            if (!section.getSectionName().equals("PNN") || !section.getSubSectionName().equals("SAMPLES")) continue;
            for (String line : section.getLines()) {
                List<String> cols = EncogFileSection.splitColumns(line);
                int index = 0;
                BasicMLData inputData = new BasicMLData(inputCount);
                int i = 0;
                while (i < inputCount) {
                    inputData.setData(i, CSVFormat.EG_FORMAT.parse(cols.get(index++)));
                    ++i;
                }
                BasicMLData idealData = new BasicMLData(outputCount);
                idealData.setData(0, CSVFormat.EG_FORMAT.parse(cols.get(index++)));
                BasicMLDataPair pair = new BasicMLDataPair(inputData, idealData);
                samples.add(pair);
            }
        }
        BasicPNN result = new BasicPNN(kernel, outmodel, inputCount, outputCount);
        if (networkParams != null) {
            result.getProperties().putAll(networkParams);
        }
        result.setSamples(samples);
        result.setError(error);
        if (sigma != null) {
            EngineArray.arrayCopy(sigma, result.getSigma());
        }
        return result;
    }

    @Override
    public void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        BasicPNN pnn = (BasicPNN)obj;
        out.addSection("PNN");
        out.addSubSection("PARAMS");
        out.addProperties(pnn.getProperties());
        out.addSubSection("NETWORK");
        out.writeProperty("error", pnn.getError());
        out.writeProperty("inputCount", pnn.getInputCount());
        out.writeProperty("kernel", PersistBasicPNN.kernelToString(pnn.getKernel()));
        out.writeProperty("outputCount", pnn.getOutputCount());
        out.writeProperty(PROPERTY_outputMode, PersistBasicPNN.outputModeToString(pnn.getOutputMode()));
        out.writeProperty("sigma", pnn.getSigma());
        out.addSubSection("SAMPLES");
        if (pnn.getSamples() != null) {
            for (MLDataPair pair : pnn.getSamples()) {
                int i = 0;
                while (i < pair.getInput().size()) {
                    out.addColumn(pair.getInput().getData(i));
                    ++i;
                }
                i = 0;
                while (i < pair.getIdeal().size()) {
                    out.addColumn(pair.getIdeal().getData(i));
                    ++i;
                }
                out.writeLine();
            }
        }
        out.flush();
    }
}

