/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation.sgd.update;

import org.encog.neural.networks.training.propagation.sgd.StochasticGradientDescent;
import org.encog.neural.networks.training.propagation.sgd.update.UpdateRule;

public class RMSPropUpdate
implements UpdateRule {
    private StochasticGradientDescent training;
    private double[] cache;
    private double eps = 1.0E-8;
    private double decayRate = 0.99;

    @Override
    public void init(StochasticGradientDescent theTraining) {
        this.training = theTraining;
        this.cache = new double[theTraining.getFlat().getWeights().length];
    }

    @Override
    public void update(double[] gradients, double[] weights) {
        int i = 0;
        while (i < weights.length) {
            int n = i;
            this.cache[n] = this.cache[n] + gradients[i] * gradients[i];
            this.cache[i] = this.decayRate * this.cache[i] + (1.0 - this.decayRate) * gradients[i] * gradients[i];
            double delta = this.training.getLearningRate() * gradients[i] / (Math.sqrt(this.cache[i]) + this.eps);
            int n2 = i++;
            weights[n2] = weights[n2] + delta;
        }
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    public double getDecayRate() {
        return this.decayRate;
    }

    public void setDecayRate(double decayRate) {
        this.decayRate = decayRate;
    }
}

