/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training;

import org.encog.mathutil.error.ErrorCalculation;
import org.encog.mathutil.randomize.generate.GenerateRandom;
import org.encog.mathutil.randomize.generate.MersenneTwisterGenerateRandom;
import org.encog.ml.CalculateScore;
import org.encog.ml.MLMethod;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.buffer.BufferedMLDataSet;

public class StochasticTrainingSetScore
implements CalculateScore {
    private final MLDataSet training;
    private final int size;
    private GenerateRandom rnd = new MersenneTwisterGenerateRandom();

    public StochasticTrainingSetScore(MLDataSet training, int theSize) {
        this.training = training;
        this.size = theSize;
    }

    @Override
    public double calculateScore(MLMethod method) {
        ErrorCalculation error = new ErrorCalculation();
        int i = 0;
        while (i < this.size) {
            int idx = this.rnd.nextInt(this.training.size());
            MLDataPair pair = this.training.get(idx);
            MLData output = ((MLRegression)method).compute(pair.getInput());
            error.updateError(output.getData(), pair.getIdealArray(), 1.0);
            ++i;
        }
        return error.calculate();
    }

    @Override
    public boolean shouldMinimize() {
        return true;
    }

    @Override
    public boolean requireSingleThreaded() {
        return this.training instanceof BufferedMLDataSet;
    }

    public MLDataSet getTraining() {
        return this.training;
    }

    public int getSize() {
        return this.size;
    }

    public GenerateRandom getRnd() {
        return this.rnd;
    }

    public void setRnd(GenerateRandom rnd) {
        this.rnd = rnd;
    }
}

