/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.flat.FlatLayer;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.structure.NetworkCODEC;

public class NeuralStructure
implements Serializable {
    private static final long serialVersionUID = -2929683885395737817L;
    private final List<Layer> layers = new ArrayList<Layer>();
    private final BasicNetwork network;
    private double connectionLimit;
    private boolean connectionLimited;
    private FlatNetwork flat;

    public NeuralStructure(BasicNetwork network) {
        this.network = network;
    }

    public final int calculateSize() {
        return NetworkCODEC.networkSize(this.network);
    }

    public final void enforceLimit() {
        if (!this.connectionLimited) {
            return;
        }
        double[] weights = this.flat.getWeights();
        int i = 0;
        while (i < weights.length) {
            if (Math.abs(weights[i]) < this.connectionLimit) {
                weights[i] = 0.0;
            }
            ++i;
        }
    }

    public void finalizeLimit() {
        String limit = this.network.getPropertyString("CONNECTION_LIMIT");
        if (limit != null) {
            try {
                this.connectionLimited = true;
                this.connectionLimit = Double.parseDouble(limit);
                this.enforceLimit();
            }
            catch (NumberFormatException e) {
                throw new NeuralNetworkError("Invalid property(CONNECTION_LIMIT):" + limit);
            }
        } else {
            this.connectionLimited = false;
            this.connectionLimit = 0.0;
        }
    }

    public final void finalizeStructure(boolean dropout) {
        if (this.layers.size() < 2) {
            throw new NeuralNetworkError("There must be at least two layers before the structure is finalized.");
        }
        FlatLayer[] flatLayers = new FlatLayer[this.layers.size()];
        int i = 0;
        while (i < this.layers.size()) {
            BasicLayer layer = (BasicLayer)this.layers.get(i);
            if (layer.getActivation() == null) {
                layer.setActivation(new ActivationLinear());
            }
            flatLayers[i] = layer;
            ++i;
        }
        this.flat = new FlatNetwork(flatLayers, dropout);
        this.finalizeLimit();
        this.layers.clear();
        this.enforceLimit();
    }

    public final void finalizeStructure() {
        this.finalizeStructure(false);
    }

    public final double getConnectionLimit() {
        return this.connectionLimit;
    }

    public final FlatNetwork getFlat() {
        this.requireFlat();
        return this.flat;
    }

    public final List<Layer> getLayers() {
        return this.layers;
    }

    public final BasicNetwork getNetwork() {
        return this.network;
    }

    public final boolean isConnectionLimited() {
        return this.connectionLimited;
    }

    public final void requireFlat() {
        if (this.flat == null) {
            throw new NeuralNetworkError("Must call finalizeStructure before using this network.");
        }
    }

    public final void setFlat(FlatNetwork flat) {
        this.flat = flat;
    }

    public final void updateProperties() {
        if (this.network.getProperties().containsKey("CONNECTION_LIMIT")) {
            this.connectionLimit = this.network.getPropertyDouble("CONNECTION_LIMIT");
            this.connectionLimited = true;
        } else {
            this.connectionLimited = false;
            this.connectionLimit = 0.0;
        }
        if (this.flat != null) {
            this.flat.setConnectionLimit(this.connectionLimit);
        }
    }
}

