/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.structure;

import java.util.ArrayList;
import org.encog.mathutil.NumericRange;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.util.EngineArray;
import org.encog.util.Format;

public class AnalyzeNetwork {
    private final NumericRange weights;
    private final NumericRange bias;
    private final NumericRange weightsAndBias;
    private final int disabledConnections;
    private final int totalConnections;
    private final double[] allValues;
    private final double[] weightValues;
    private final double[] biasValues;

    public AnalyzeNetwork(BasicNetwork network) {
        int assignDisabled = 0;
        int assignedTotal = 0;
        ArrayList<Double> biasList = new ArrayList<Double>();
        ArrayList<Double> weightList = new ArrayList<Double>();
        ArrayList<Double> allList = new ArrayList<Double>();
        int layerNumber = 0;
        while (layerNumber < network.getLayerCount() - 1) {
            double v;
            int toNeuron;
            int fromCount = network.getLayerNeuronCount(layerNumber);
            int fromBiasCount = network.getLayerTotalNeuronCount(layerNumber);
            int toCount = network.getLayerNeuronCount(layerNumber + 1);
            int fromNeuron = 0;
            while (fromNeuron < fromCount) {
                toNeuron = 0;
                while (toNeuron < toCount) {
                    v = network.getWeight(layerNumber, fromNeuron, toNeuron);
                    if (network.getStructure().isConnectionLimited() && Math.abs(v) < network.getStructure().getConnectionLimit()) {
                        ++assignDisabled;
                    }
                    ++assignedTotal;
                    weightList.add(v);
                    allList.add(v);
                    ++toNeuron;
                }
                ++fromNeuron;
            }
            if (fromCount != fromBiasCount) {
                int biasNeuron = fromCount;
                toNeuron = 0;
                while (toNeuron < toCount) {
                    v = network.getWeight(layerNumber, biasNeuron, toNeuron);
                    if (network.getStructure().isConnectionLimited() && Math.abs(v) < network.getStructure().getConnectionLimit()) {
                        ++assignDisabled;
                    }
                    ++assignedTotal;
                    biasList.add(v);
                    allList.add(v);
                    ++toNeuron;
                }
            }
            ++layerNumber;
        }
        for (Layer layer : network.getStructure().getLayers()) {
            if (!layer.hasBias()) continue;
            int i = 0;
            while (i < layer.getNeuronCount()) {
                ++i;
            }
        }
        this.disabledConnections = assignDisabled;
        this.totalConnections = assignedTotal;
        this.weights = new NumericRange(weightList);
        this.bias = new NumericRange(biasList);
        this.weightsAndBias = new NumericRange(allList);
        this.weightValues = EngineArray.listToDouble(weightList);
        this.allValues = EngineArray.listToDouble(allList);
        this.biasValues = EngineArray.listToDouble(biasList);
    }

    public final double[] getAllValues() {
        return this.allValues;
    }

    public final NumericRange getBias() {
        return this.bias;
    }

    public final double[] getBiasValues() {
        return this.biasValues;
    }

    public final int getDisabledConnections() {
        return this.disabledConnections;
    }

    public final int getTotalConnections() {
        return this.totalConnections;
    }

    public final NumericRange getWeights() {
        return this.weights;
    }

    public final NumericRange getWeightsAndBias() {
        return this.weightsAndBias;
    }

    public final double[] getWeightValues() {
        return this.weightValues;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder();
        result.append("All Values : ");
        result.append(this.weightsAndBias.toString());
        result.append("\n");
        result.append("Bias : ");
        result.append(this.bias.toString());
        result.append("\n");
        result.append("Weights    : ");
        result.append(this.weights.toString());
        result.append("\n");
        result.append("Disabled   : ");
        result.append(Format.formatInteger(this.disabledConnections));
        result.append("\n");
        return result.toString();
    }
}

