/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training.opp;

import java.io.Serializable;
import java.util.Random;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.ea.genome.Genome;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.opp.NEATMutation;

public class NEATMutateRemoveLink
extends NEATMutation
implements Serializable {
    public static final int MIN_LINK = 5;

    @Override
    public void performOperation(Random rnd, Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        NEATGenome target = this.obtainGenome(parents, parentIndex, offspring, offspringIndex);
        if (target.getLinksChromosome().size() < 5) {
            return;
        }
        int index = RangeRandomizer.randomInt(0, target.getLinksChromosome().size() - 1);
        NEATLinkGene targetGene = target.getLinksChromosome().get(index);
        target.getLinksChromosome().remove(index);
        if (!this.isNeuronNeeded(target, targetGene.getFromNeuronID())) {
            this.removeNeuron(target, targetGene.getFromNeuronID());
        }
        if (!this.isNeuronNeeded(target, targetGene.getToNeuronID())) {
            this.removeNeuron(target, targetGene.getToNeuronID());
        }
    }
}

