/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.freeform.training;

import java.io.Serializable;
import org.encog.mathutil.EncogMath;
import org.encog.ml.data.MLDataSet;
import org.encog.neural.freeform.FreeformConnection;
import org.encog.neural.freeform.FreeformNetwork;
import org.encog.neural.freeform.task.ConnectionTask;
import org.encog.neural.freeform.training.FreeformPropagationTraining;
import org.encog.neural.networks.training.propagation.TrainingContinuation;

public class FreeformResilientPropagation
extends FreeformPropagationTraining
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int TEMP_GRADIENT = 0;
    public static final int TEMP_LAST_GRADIENT = 1;
    public static final int TEMP_UPDATE = 2;
    public static final int TEMP_LAST_WEIGHT_DELTA = 3;
    private final double maxStep;

    public FreeformResilientPropagation(FreeformNetwork theNetwork, MLDataSet theTraining) {
        this(theNetwork, theTraining, 0.1, 50.0);
    }

    public FreeformResilientPropagation(FreeformNetwork theNetwork, MLDataSet theTraining, final double initialUpdate, double theMaxStep) {
        super(theNetwork, theTraining);
        this.maxStep = theMaxStep;
        theNetwork.tempTrainingAllocate(1, 4);
        theNetwork.performConnectionTask(new ConnectionTask(){

            @Override
            public void task(FreeformConnection c) {
                c.setTempTraining(2, initialUpdate);
            }
        });
    }

    @Override
    protected void learnConnection(FreeformConnection connection) {
        int change = EncogMath.sign(connection.getTempTraining(0) * connection.getTempTraining(1));
        double weightChange = 0.0;
        if (change > 0) {
            double delta = connection.getTempTraining(2) * 1.2;
            delta = Math.min(delta, this.maxStep);
            weightChange = (double)EncogMath.sign(connection.getTempTraining(0)) * delta;
            connection.setTempTraining(2, delta);
            connection.setTempTraining(1, connection.getTempTraining(0));
        } else if (change < 0) {
            double delta = connection.getTempTraining(2) * 0.5;
            delta = Math.max(delta, 1.0E-6);
            connection.setTempTraining(2, delta);
            weightChange = -connection.getTempTraining(3);
            connection.setTempTraining(1, 0.0);
        } else if (change == 0) {
            double delta = connection.getTempTraining(2);
            weightChange = (double)EncogMath.sign(connection.getTempTraining(0)) * delta;
            connection.setTempTraining(1, connection.getTempTraining(0));
        }
        connection.addWeight(weightChange);
        connection.setTempTraining(3, weightChange);
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
    }
}

