/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.art;

import org.encog.mathutil.matrices.Matrix;
import org.encog.ml.MLClassification;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.specific.BiPolarNeuralData;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.art.ART;

public class ART1
extends ART
implements MLResettable,
MLClassification {
    private static final long serialVersionUID = 1L;
    private int winner;
    private double a1 = 1.0;
    private double b1 = 1.5;
    private double c1 = 5.0;
    private double d1 = 0.9;
    private double l = 3.0;
    private double vigilance = 0.9;
    private transient boolean[] inhibitF2;
    private int noWinner;
    private BiPolarNeuralData outputF1;
    private BiPolarNeuralData outputF2;
    private int f1Count;
    private int f2Count;
    private Matrix weightsF1toF2;
    private Matrix weightsF2toF1;

    public ART1() {
    }

    public ART1(int theF1Count, int theF2Count) {
        this.f1Count = theF1Count;
        this.f2Count = theF2Count;
        this.weightsF1toF2 = new Matrix(this.f1Count, this.f2Count);
        this.weightsF2toF1 = new Matrix(this.f2Count, this.f1Count);
        this.inhibitF2 = new boolean[this.f2Count];
        this.outputF1 = new BiPolarNeuralData(this.f1Count);
        this.outputF2 = new BiPolarNeuralData(this.f2Count);
        this.noWinner = this.f2Count;
        this.reset();
    }

    public void adjustWeights() {
        int i = 0;
        while (i < this.f1Count) {
            if (this.outputF1.getBoolean(i)) {
                double magnitudeInput = this.magnitude(this.outputF1);
                this.weightsF1toF2.set(i, this.winner, 1.0);
                this.weightsF2toF1.set(this.winner, i, this.l / (this.l - 1.0 + magnitudeInput));
            } else {
                this.weightsF1toF2.set(i, this.winner, 0.0);
                this.weightsF2toF1.set(this.winner, i, 0.0);
            }
            ++i;
        }
    }

    @Override
    public int classify(MLData input) {
        BiPolarNeuralData input2 = new BiPolarNeuralData(this.f1Count);
        BiPolarNeuralData output = new BiPolarNeuralData(this.f2Count);
        if (input.size() != input2.size()) {
            throw new NeuralNetworkError("Input array size does not match.");
        }
        int i = 0;
        while (i < input2.size()) {
            input2.setData(i, input.getData(i) > 0.0);
            ++i;
        }
        this.compute(input2, output);
        if (this.hasWinner()) {
            return this.winner;
        }
        return -1;
    }

    public void compute(BiPolarNeuralData input, BiPolarNeuralData output) {
        int i = 0;
        while (i < this.f2Count) {
            this.inhibitF2[i] = false;
            ++i;
        }
        boolean resonance = false;
        boolean exhausted = false;
        do {
            this.setInput(input);
            this.computeF2();
            this.getOutput(output);
            if (this.winner != this.noWinner) {
                this.computeF1(input);
                double magnitudeInput1 = this.magnitude(input);
                double magnitudeInput2 = this.magnitude(this.outputF1);
                if (magnitudeInput2 / magnitudeInput1 < this.vigilance) {
                    this.inhibitF2[this.winner] = true;
                    continue;
                }
                resonance = true;
                continue;
            }
            exhausted = true;
        } while (!resonance && !exhausted);
        if (resonance) {
            this.adjustWeights();
        }
    }

    public MLData compute(MLData input) {
        if (!(input instanceof BiPolarNeuralData)) {
            throw new NeuralNetworkError("Input to ART1 logic network must be BiPolarNeuralData.");
        }
        BiPolarNeuralData output = new BiPolarNeuralData(this.f1Count);
        this.compute((BiPolarNeuralData)input, output);
        return output;
    }

    private void computeF1(BiPolarNeuralData input) {
        int i = 0;
        while (i < this.f1Count) {
            double sum = this.weightsF1toF2.get(i, this.winner) * (double)(this.outputF2.getBoolean(this.winner) ? 1 : 0);
            double activation = ((double)(input.getBoolean(i) ? 1 : 0) + this.d1 * sum - this.b1) / (1.0 + this.a1 * ((double)(input.getBoolean(i) ? 1 : 0) + this.d1 * sum) + this.c1);
            this.outputF1.setData(i, activation > 0.0);
            ++i;
        }
    }

    private void computeF2() {
        double maxOut = Double.NEGATIVE_INFINITY;
        this.winner = this.noWinner;
        int i = 0;
        while (i < this.f2Count) {
            if (!this.inhibitF2[i]) {
                double sum = 0.0;
                int j = 0;
                while (j < this.f1Count) {
                    sum += this.weightsF2toF1.get(i, j) * (double)(this.outputF1.getBoolean(j) ? 1 : 0);
                    ++j;
                }
                if (sum > maxOut) {
                    maxOut = sum;
                    this.winner = i;
                }
            }
            this.outputF2.setData(i, false);
            ++i;
        }
        if (this.winner != this.noWinner) {
            this.outputF2.setData(this.winner, true);
        }
    }

    public double getA1() {
        return this.a1;
    }

    public double getB1() {
        return this.b1;
    }

    public double getC1() {
        return this.c1;
    }

    public double getD1() {
        return this.d1;
    }

    public int getF1Count() {
        return this.f1Count;
    }

    public int getF2Count() {
        return this.f2Count;
    }

    @Override
    public int getInputCount() {
        return this.f1Count;
    }

    public double getL() {
        return this.l;
    }

    public int getNoWinner() {
        return this.noWinner;
    }

    private void getOutput(BiPolarNeuralData output) {
        int i = 0;
        while (i < this.f2Count) {
            output.setData(i, this.outputF2.getBoolean(i));
            ++i;
        }
    }

    @Override
    public int getOutputCount() {
        return this.f2Count;
    }

    public double getVigilance() {
        return this.vigilance;
    }

    public Matrix getWeightsF1toF2() {
        return this.weightsF1toF2;
    }

    public Matrix getWeightsF2toF1() {
        return this.weightsF2toF1;
    }

    public int getWinner() {
        return this.winner;
    }

    public boolean hasWinner() {
        return this.winner != this.noWinner;
    }

    public double magnitude(BiPolarNeuralData input) {
        double result = 0.0;
        int i = 0;
        while (i < this.f1Count) {
            result += (double)(input.getBoolean(i) ? 1 : 0);
            ++i;
        }
        return result;
    }

    @Override
    public void reset() {
        this.reset(0);
    }

    @Override
    public void reset(int seed) {
        int i = 0;
        while (i < this.f1Count) {
            int j = 0;
            while (j < this.f2Count) {
                this.weightsF1toF2.set(i, j, (this.b1 - 1.0) / this.d1 + 0.2);
                this.weightsF2toF1.set(j, i, this.l / (this.l - 1.0 + (double)this.f1Count) - 0.1);
                ++j;
            }
            ++i;
        }
    }

    public void setA1(double theA1) {
        this.a1 = theA1;
    }

    public void setB1(double theB1) {
        this.b1 = theB1;
    }

    public void setC1(double theC1) {
        this.c1 = theC1;
    }

    public void setD1(double theD1) {
        this.d1 = theD1;
    }

    public void setF1Count(int i) {
        this.f1Count = i;
        this.outputF1 = new BiPolarNeuralData(this.f1Count);
    }

    public void setF2Count(int i) {
        this.f2Count = i;
        this.inhibitF2 = new boolean[this.f2Count];
        this.outputF2 = new BiPolarNeuralData(this.f2Count);
    }

    private void setInput(BiPolarNeuralData input) {
        int i = 0;
        while (i < this.f1Count) {
            double activation = (double)(input.getBoolean(i) ? 1 : 0) / (1.0 + this.a1 * ((double)(input.getBoolean(i) ? 1 : 0) + this.b1) + this.c1);
            this.outputF1.setData(i, activation > 0.0);
            ++i;
        }
    }

    public void setL(double theL) {
        this.l = theL;
    }

    public void setNoWinner(int i) {
        this.noWinner = i;
    }

    public void setVigilance(double theVigilance) {
        this.vigilance = theVigilance;
    }

    public void setWeightsF1toF2(Matrix matrix) {
        this.weightsF1toF2 = matrix;
    }

    public void setWeightsF2toF1(Matrix matrix) {
        this.weightsF2toF1 = matrix;
    }
}

