/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.train.strategy.end;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.end.EndTrainingStrategy;

public class EndMinutesStrategy
implements EndTrainingStrategy {
    private final int minutes;
    private long startedTime;
    private boolean started;
    private final AtomicInteger minutesLeft = new AtomicInteger(0);

    public EndMinutesStrategy(int minutes) {
        this.minutes = minutes;
        this.started = false;
        this.minutesLeft.set(minutes);
    }

    @Override
    public boolean shouldStop() {
        boolean timeUp;
        boolean bl = timeUp = this.getMinutesLeft() <= 0;
        return this.started && timeUp;
    }

    @Override
    public void init(MLTrain train) {
        this.started = true;
        this.startedTime = System.currentTimeMillis();
    }

    @Override
    public void postIteration() {
        long now = System.currentTimeMillis();
        long minutesPassed = (now - this.startedTime) / TimeUnit.MINUTES.toMillis(1L);
        this.minutesLeft.set((int)Math.ceil((long)this.getMinutes() - minutesPassed));
    }

    @Override
    public void preIteration() {
    }

    public int getMinutesLeft() {
        return this.minutesLeft.get();
    }

    public int getMinutes() {
        return this.minutes;
    }
}

