/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.train.strategy;

import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.Strategy;
import org.encog.util.logging.EncogLogging;

public class HybridStrategy
implements Strategy {
    public static final double DEFAULT_MIN_IMPROVEMENT = 1.0E-5;
    public static final int DEFAULT_TOLERATE_CYCLES = 10;
    public static final int DEFAULT_ALTERNATE_CYCLES = 5;
    private MLTrain mainTrain;
    private final MLTrain altTrain;
    private double lastImprovement;
    private double lastError;
    private boolean ready;
    private int lastHybrid;
    private final double minImprovement;
    private final int tolerateMinImprovement;
    private final int alternateCycles;

    public HybridStrategy(MLTrain altTrain) {
        this(altTrain, 1.0E-5, 10, 5);
    }

    public HybridStrategy(MLTrain altTrain, double minImprovement, int tolerateMinImprovement, int alternateCycles) {
        this.altTrain = altTrain;
        this.ready = false;
        this.lastHybrid = 0;
        this.minImprovement = minImprovement;
        this.tolerateMinImprovement = tolerateMinImprovement;
        this.alternateCycles = alternateCycles;
    }

    @Override
    public void init(MLTrain train) {
        this.mainTrain = train;
    }

    @Override
    public void postIteration() {
        if (this.ready) {
            double currentError = this.mainTrain.getError();
            this.lastImprovement = (currentError - this.lastError) / this.lastError;
            EncogLogging.log(0, "Last improvement: " + this.lastImprovement);
            if (this.lastImprovement > 0.0 || Math.abs(this.lastImprovement) < this.minImprovement) {
                ++this.lastHybrid;
                if (this.lastHybrid > this.tolerateMinImprovement) {
                    this.lastHybrid = 0;
                    EncogLogging.log(0, "Performing hybrid cycle");
                    int i = 0;
                    while (i < this.alternateCycles) {
                        this.altTrain.iteration();
                        ++i;
                    }
                }
            }
        } else {
            this.ready = true;
        }
    }

    @Override
    public void preIteration() {
        this.lastError = this.mainTrain.getError();
    }
}

