/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.train.rewrite;

import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.rules.RewriteRule;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ExpressionValue;

public class RewriteConstants
implements RewriteRule {
    private boolean rewritten;

    @Override
    public boolean rewrite(Genome g) {
        EncogProgram program = (EncogProgram)g;
        this.rewritten = false;
        ProgramNode rootNode = program.getRootNode();
        ProgramNode rewrite = this.rewriteNode(rootNode);
        if (rewrite != null) {
            program.setRootNode(rewrite);
        }
        return this.rewritten;
    }

    private ProgramNode rewriteNode(ProgramNode node) {
        ProgramNode rewrite = this.tryNodeRewrite(node);
        if (rewrite != null) {
            return rewrite;
        }
        int i = 0;
        while (i < node.getChildNodes().size()) {
            ProgramNode childNode = (ProgramNode)node.getChildNodes().get(i);
            rewrite = this.rewriteNode(childNode);
            if (rewrite != null) {
                node.getChildNodes().remove(i);
                node.getChildNodes().add(i, rewrite);
                this.rewritten = true;
            }
            ++i;
        }
        return null;
    }

    private ProgramNode tryNodeRewrite(ProgramNode parentNode) {
        ProgramNode result = null;
        if (parentNode.isLeaf()) {
            return null;
        }
        if (parentNode.allConstDescendants()) {
            ExpressionValue v = parentNode.evaluate();
            double ck = v.toFloatValue();
            if (Double.isNaN(ck) || Double.isInfinite(ck)) {
                return result;
            }
            result = parentNode.getOwner().getContext().getFunctions().factorProgramNode("#const", parentNode.getOwner(), new ProgramNode[0]);
            result.getData()[0] = Math.abs(ck - (double)((int)ck)) < 1.0E-13 ? new ExpressionValue((int)ck) : v;
        }
        return result;
    }
}

