/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.hmm.alog;

import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.MLSequenceSet;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.ml.data.basic.BasicMLSequenceSet;
import org.encog.ml.hmm.HiddenMarkovModel;

public class MarkovGenerator {
    private final HiddenMarkovModel hmm;
    private int currentState;

    public MarkovGenerator(HiddenMarkovModel hmm) {
        this.hmm = hmm;
        this.newSequence();
    }

    public MLSequenceSet generateSequences(int observationCount, int observationLength) {
        BasicMLSequenceSet result = new BasicMLSequenceSet();
        int i = 0;
        while (i < observationCount) {
            result.startNewSequence();
            result.add(this.observationSequence(observationLength));
            ++i;
        }
        return result;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public void newSequence() {
        double rand = Math.random();
        double current = 0.0;
        int i = 0;
        while (i < this.hmm.getStateCount() - 1) {
            if ((current += this.hmm.getPi(i)) > rand) {
                this.currentState = i;
                return;
            }
            ++i;
        }
        this.currentState = this.hmm.getStateCount() - 1;
    }

    public MLDataPair observation() {
        MLDataPair o = this.hmm.getStateDistribution(this.currentState).generate();
        double rand = Math.random();
        int j = 0;
        while (j < this.hmm.getStateCount() - 1) {
            double d;
            rand -= this.hmm.getTransitionProbability(this.currentState, j);
            if (d < 0.0) {
                this.currentState = j;
                return o;
            }
            ++j;
        }
        this.currentState = this.hmm.getStateCount() - 1;
        return o;
    }

    public MLDataSet observationSequence(int length) {
        BasicMLDataSet sequence = new BasicMLDataSet();
        while (length-- > 0) {
            sequence.add(this.observation());
        }
        this.newSequence();
        return sequence;
    }
}

