/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.hmm.alog;

import org.encog.ml.data.MLDataSet;
import org.encog.ml.hmm.HiddenMarkovModel;
import org.encog.ml.hmm.alog.ForwardBackwardScaledCalculator;
import org.encog.ml.hmm.alog.MarkovGenerator;

public class KullbackLeiblerDistanceCalculator {
    private int len = 1000;
    private int sequenceCount = 10;

    public double distance(HiddenMarkovModel hmm1, HiddenMarkovModel hmm2) {
        double distance = 0.0;
        int i = 0;
        while (i < this.sequenceCount) {
            MLDataSet oseq = new MarkovGenerator(hmm1).observationSequence(this.len);
            distance += (new ForwardBackwardScaledCalculator(oseq, hmm1).lnProbability() - new ForwardBackwardScaledCalculator(oseq, hmm2).lnProbability()) / (double)this.len;
            ++i;
        }
        return distance / (double)this.sequenceCount;
    }

    public int getLen() {
        return this.len;
    }

    public int getSequenceCount() {
        return this.sequenceCount;
    }

    public void setLen(int len) {
        this.len = len;
    }

    public void setSequenceCount(int sequenceCount) {
        this.sequenceCount = sequenceCount;
    }
}

