/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.hmm;

import java.io.Serializable;
import java.util.Iterator;
import org.encog.EncogError;
import org.encog.ml.BasicML;
import org.encog.ml.MLStateSequence;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.hmm.alog.ForwardBackwardCalculator;
import org.encog.ml.hmm.alog.ForwardBackwardScaledCalculator;
import org.encog.ml.hmm.alog.ViterbiCalculator;
import org.encog.ml.hmm.distributions.ContinousDistribution;
import org.encog.ml.hmm.distributions.DiscreteDistribution;
import org.encog.ml.hmm.distributions.StateDistribution;

public class HiddenMarkovModel
extends BasicML
implements MLStateSequence,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String TAG_STATES = "sates";
    public static final String TAG_ITEMS = "items";
    public static final String TAG_PI = "pi";
    public static final String TAG_TRANSITION = "transition";
    public static final String TAG_DIST_TYPE = "type";
    public static final String TAG_MEAN = "mean";
    public static final String TAG_COVARIANCE = "covariance";
    public static final String TAG_PROBABILITIES = "probabilities";
    private double[] pi;
    private double[][] transitionProbability;
    private final StateDistribution[] stateDistributions;
    private final int[] items;

    public HiddenMarkovModel(int states) {
        this.items = null;
        this.pi = new double[states];
        this.transitionProbability = new double[states][states];
        this.stateDistributions = new StateDistribution[states];
        int i = 0;
        while (i < states) {
            this.pi[i] = 1.0 / (double)states;
            this.stateDistributions[i] = new ContinousDistribution(this.getStateCount());
            int j = 0;
            while (j < states) {
                this.transitionProbability[i][j] = 1.0 / (double)states;
                ++j;
            }
            ++i;
        }
    }

    public HiddenMarkovModel(int theStates, int theItems) {
        this(theStates, new int[]{theItems});
    }

    public HiddenMarkovModel(int theStates, int[] theItems) {
        this.items = theItems;
        this.pi = new double[theStates];
        this.transitionProbability = new double[theStates][theStates];
        this.stateDistributions = new StateDistribution[theStates];
        int i = 0;
        while (i < theStates) {
            this.pi[i] = 1.0 / (double)theStates;
            this.stateDistributions[i] = new DiscreteDistribution(this.items);
            int j = 0;
            while (j < theStates) {
                this.transitionProbability[i][j] = 1.0 / (double)theStates;
                ++j;
            }
            ++i;
        }
    }

    public HiddenMarkovModel clone() throws CloneNotSupportedException {
        HiddenMarkovModel hmm = this.cloneStructure();
        hmm.pi = (double[])this.pi.clone();
        hmm.transitionProbability = (double[][])this.transitionProbability.clone();
        int i = 0;
        while (i < this.transitionProbability.length) {
            hmm.transitionProbability[i] = (double[])this.transitionProbability[i].clone();
            ++i;
        }
        i = 0;
        while (i < hmm.stateDistributions.length) {
            hmm.stateDistributions[i] = this.stateDistributions[i].clone();
            ++i;
        }
        return hmm;
    }

    public HiddenMarkovModel cloneStructure() {
        HiddenMarkovModel hmm = this.isDiscrete() ? new HiddenMarkovModel(this.getStateCount(), this.items) : new HiddenMarkovModel(this.getStateCount());
        return hmm;
    }

    public StateDistribution createNewDistribution() {
        if (this.isContinuous()) {
            return new ContinousDistribution(this.getStateCount());
        }
        return new DiscreteDistribution(this.items);
    }

    public double getPi(int i) {
        return this.pi[i];
    }

    public int getStateCount() {
        return this.pi.length;
    }

    public StateDistribution getStateDistribution(int i) {
        return this.stateDistributions[i];
    }

    @Override
    public int[] getStatesForSequence(MLDataSet seq) {
        return new ViterbiCalculator(seq, this).stateSequence();
    }

    public double getTransitionProbability(int i, int j) {
        return this.transitionProbability[i][j];
    }

    public boolean isContinuous() {
        return this.items == null;
    }

    public boolean isDiscrete() {
        return !this.isContinuous();
    }

    public double lnProbability(MLDataSet seq) {
        return new ForwardBackwardScaledCalculator(seq, this).lnProbability();
    }

    @Override
    public double probability(MLDataSet seq) {
        return new ForwardBackwardCalculator(seq, this).probability();
    }

    @Override
    public double probability(MLDataSet seq, int[] states) {
        if (seq.size() != states.length || seq.size() < 1) {
            throw new IllegalArgumentException();
        }
        double probability = this.getPi(states[0]);
        Iterator oseqIterator = seq.iterator();
        int i = 0;
        while (i < states.length - 1) {
            probability *= this.getStateDistribution(states[i]).probability((MLDataPair)oseqIterator.next()) * this.getTransitionProbability(states[i], states[i + 1]);
            ++i;
        }
        return probability * this.getStateDistribution(states[states.length - 1]).probability(seq.get(states.length - 1));
    }

    public void setPi(int i, double value) {
        this.pi[i] = value;
    }

    public void setStateDistribution(int i, StateDistribution dist) {
        this.stateDistributions[i] = dist;
    }

    public void setTransitionProbability(int i, int j, double value) {
        this.transitionProbability[i][j] = value;
    }

    @Override
    public void updateProperties() {
    }

    public int[] getItems() {
        return this.items;
    }

    public double[] getPi() {
        return this.pi;
    }

    public double[][] getTransitionProbability() {
        return this.transitionProbability;
    }

    public void setTransitionProbability(double[][] data) {
        if (data.length != this.transitionProbability.length || data[0].length != this.transitionProbability[0].length) {
            throw new EncogError("Dimensions of transationalProbability must match number of states.");
        }
        this.transitionProbability = data;
    }

    public void setPi(double[] data) {
        if (data.length != this.pi.length) {
            throw new EncogError("The length of pi, must match the number of states.");
        }
        this.pi = data;
    }
}

