/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.fitting.gaussian;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixMath;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLData;

public class GaussianFitting
implements MLRegression {
    private double[] weights;
    private int inputCount;
    private final Matrix sigma;
    private final Matrix mu;
    private Matrix sigmaInverse;
    private double dimFactor;
    private double normConst;

    public GaussianFitting(int theInputCount) {
        this.mu = new Matrix(1, theInputCount);
        this.sigma = new Matrix(theInputCount, theInputCount);
        this.inputCount = theInputCount;
        this.weights = new double[theInputCount + 1];
    }

    public double[] getWeights() {
        return this.weights;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public int getOutputCount() {
        return 1;
    }

    @Override
    public MLData compute(MLData input) {
        BasicMLData result = new BasicMLData(1);
        Matrix m1 = Matrix.createRowMatrix(input.getData());
        Matrix m2 = MatrixMath.subtract(m1, this.mu);
        Matrix m3 = MatrixMath.transpose(m2);
        Matrix m4 = MatrixMath.multiply(this.sigmaInverse, m3);
        Matrix m5 = MatrixMath.multiply(m4, m2);
        result.setData(0, m5.get(0, 0));
        return result;
    }

    public Matrix getSigma() {
        return this.sigma;
    }

    public Matrix getMu() {
        return this.mu;
    }

    public void finalizeTraining() {
        this.sigmaInverse = this.sigma.inverse();
        this.dimFactor = Math.pow(Math.PI * 2, (double)this.getInputCount() / 2.0);
        this.normConst = Math.sqrt(MatrixMath.determinant(this.sigma)) * this.dimFactor;
    }
}

