/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.train;

import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.ea.population.Population;
import org.encog.ml.ea.score.adjust.ComplexityAdjustedScore;
import org.encog.ml.ea.train.basic.TrainEA;
import org.encog.ml.prg.PrgCODEC;
import org.encog.ml.prg.opp.ConstMutation;
import org.encog.ml.prg.opp.SubtreeCrossover;
import org.encog.ml.prg.opp.SubtreeMutation;
import org.encog.ml.prg.species.PrgSpeciation;
import org.encog.ml.prg.train.PrgPopulation;
import org.encog.ml.prg.train.rewrite.RewriteAlgebraic;
import org.encog.ml.prg.train.rewrite.RewriteConstants;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.training.TrainingSetScore;

public class EPLGAFactory {
    public MLTrain create(MLMethod method, MLDataSet training, String argsStr) {
        PrgPopulation pop = (PrgPopulation)method;
        TrainingSetScore score = new TrainingSetScore(training);
        TrainEA train = new TrainEA((Population)pop, score);
        pop.getRules().addRewriteRule(new RewriteConstants());
        pop.getRules().addRewriteRule(new RewriteAlgebraic());
        train.setCODEC(new PrgCODEC());
        train.addOperation(0.8, new SubtreeCrossover());
        train.addOperation(0.1, new SubtreeMutation(pop.getContext(), 4));
        train.addOperation(0.1, new ConstMutation(pop.getContext(), 0.5, 1.0));
        train.addScoreAdjuster(new ComplexityAdjustedScore());
        train.setSpeciation(new PrgSpeciation());
        return train;
    }
}

